/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.hash;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactoryFactoryForgeBase;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnique;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedFactoryFactory;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropertyHashedFactoryFactoryForge
extends EventTableFactoryFactoryForgeBase {
    private final String[] indexedProps;
    private final EventType eventType;
    private final boolean unique;
    private final CoercionDesc hashCoercionDesc;
    private final MultiKeyClassRef multiKeyClassRef;

    public PropertyHashedFactoryFactoryForge(int indexedStreamNum, Integer subqueryNum, boolean isFireAndForget, String[] indexedProps, EventType eventType, boolean unique, CoercionDesc hashCoercionDesc, MultiKeyClassRef multiKeyClassRef) {
        super(indexedStreamNum, subqueryNum, isFireAndForget);
        this.indexedProps = indexedProps;
        this.eventType = eventType;
        this.unique = unique;
        this.hashCoercionDesc = hashCoercionDesc;
        this.multiKeyClassRef = multiKeyClassRef;
    }

    @Override
    protected Class typeOf() {
        return PropertyHashedFactoryFactory.class;
    }

    @Override
    protected List<CodegenExpression> additionalParams(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        ArrayList<CodegenExpression> params = new ArrayList<CodegenExpression>();
        params.add(CodegenExpressionBuilder.constant(this.indexedProps));
        params.add(CodegenExpressionBuilder.constant(this.hashCoercionDesc.getCoercionTypes()));
        params.add(CodegenExpressionBuilder.constant(this.unique));
        Class[] propertyTypes = EventTypeUtility.getPropertyTypes(this.eventType, this.indexedProps);
        EventPropertyGetterSPI[] getters = EventTypeUtility.getGetters(this.eventType, this.indexedProps);
        CodegenExpression getter = MultiKeyCodegen.codegenGetterMayMultiKey(this.eventType, getters, propertyTypes, this.hashCoercionDesc.getCoercionTypes(), this.multiKeyClassRef, method, classScope);
        params.add(getter);
        params.add(CodegenExpressionBuilder.constantNull());
        params.add(this.multiKeyClassRef.getExprMKSerde(method, classScope));
        return params;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.indexedStreamNum + " propertyNames=" + Arrays.toString(this.indexedProps);
    }

    @Override
    public Class getEventTableClass() {
        return this.unique ? PropertyHashedEventTableUnique.class : PropertyHashedEventTable.class;
    }
}

