/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.unindexed;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.unindexed.UnindexedEventTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class UnindexedEventTableImpl
extends UnindexedEventTable {
    private Set<EventBean> eventSet = new LinkedHashSet<EventBean>();

    public UnindexedEventTableImpl(int streamNum) {
        super(streamNum);
    }

    @Override
    public void clear() {
        this.eventSet.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        exprEvaluatorContext.getInstrumentationProvider().qIndexAddRemove(this, newData, oldData);
        if (newData != null) {
            Collections.addAll(this.eventSet, newData);
        }
        if (oldData != null) {
            for (EventBean removeEvent : oldData) {
                this.eventSet.remove(removeEvent);
            }
        }
        exprEvaluatorContext.getInstrumentationProvider().aIndexAddRemove();
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            Collections.addAll(this.eventSet, events);
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean removeEvent : events) {
                this.eventSet.remove(removeEvent);
            }
        }
    }

    @Override
    public void add(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventSet.add(event);
    }

    @Override
    public void remove(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventSet.remove(event);
    }

    @Override
    public boolean isEmpty() {
        return this.eventSet.isEmpty();
    }

    @Override
    public Set<EventBean> getEventSet() {
        return this.eventSet;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.eventSet.iterator();
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.eventSet.size();
    }

    @Override
    public Object getIndex() {
        return this.eventSet;
    }

    @Override
    public Class getProviderClass() {
        return UnindexedEventTable.class;
    }
}

