/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.analyze;

import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.type.OuterJoinType;
import java.util.List;

public class OuterJoinAnalyzer {
    public static QueryGraphForge analyze(OuterJoinDesc[] outerJoinDescList, QueryGraphForge queryGraph) {
        for (OuterJoinDesc outerJoinDesc : outerJoinDescList) {
            if (outerJoinDesc.getOptLeftNode() == null) continue;
            ExprIdentNode identNodeLeft = outerJoinDesc.getOptLeftNode();
            ExprIdentNode identNodeRight = outerJoinDesc.getOptRightNode();
            OuterJoinAnalyzer.add(queryGraph, identNodeLeft, identNodeRight);
            if (outerJoinDesc.getAdditionalLeftNodes() == null) continue;
            for (int i = 0; i < outerJoinDesc.getAdditionalLeftNodes().length; ++i) {
                OuterJoinAnalyzer.add(queryGraph, outerJoinDesc.getAdditionalLeftNodes()[i], outerJoinDesc.getAdditionalRightNodes()[i]);
            }
        }
        return queryGraph;
    }

    private static void add(QueryGraphForge queryGraph, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight) {
        queryGraph.addStrictEquals(identNodeLeft.getStreamId(), identNodeLeft.getResolvedPropertyName(), identNodeLeft, identNodeRight.getStreamId(), identNodeRight.getResolvedPropertyName(), identNodeRight);
    }

    public static boolean optionalStreamsIfAny(List<OuterJoinDesc> outerJoinDescList) {
        if (outerJoinDescList == null || outerJoinDescList.size() == 0) {
            return false;
        }
        for (OuterJoinDesc outerJoinDesc : outerJoinDescList) {
            if (outerJoinDesc.getOuterJoinType() == OuterJoinType.INNER) continue;
            return true;
        }
        return false;
    }
}

