/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.assemble;

import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class BaseAssemblyNodeFactory
implements CodegenMakeable<SAIFFInitializeSymbol> {
    protected BaseAssemblyNodeFactory parentNode;
    protected final List<BaseAssemblyNodeFactory> childNodes;
    protected final int streamNum;
    protected final int numStreams;

    protected BaseAssemblyNodeFactory(int streamNum, int numStreams) {
        this.streamNum = streamNum;
        this.numStreams = numStreams;
        this.childNodes = new ArrayList<BaseAssemblyNodeFactory>(4);
    }

    public abstract BaseAssemblyNode makeAssemblerUnassociated();

    public abstract void print(IndentWriter var1);

    public void setParent(BaseAssemblyNodeFactory parent) {
        this.parentNode = parent;
    }

    public BaseAssemblyNodeFactory getParentNode() {
        return this.parentNode;
    }

    public void addChild(BaseAssemblyNodeFactory childNode) {
        childNode.parentNode = this;
        this.childNodes.add(childNode);
    }

    protected int getStreamNum() {
        return this.streamNum;
    }

    public List<BaseAssemblyNodeFactory> getChildNodes() {
        return this.childNodes;
    }

    public void printDescendends(IndentWriter indentWriter) {
        this.print(indentWriter);
        for (BaseAssemblyNodeFactory child : this.childNodes) {
            indentWriter.incrIndent();
            child.print(indentWriter);
            indentWriter.decrIndent();
        }
    }

    public static List<BaseAssemblyNodeFactory> getDescendentNodesBottomUp(BaseAssemblyNodeFactory topNode) {
        int deepLevel;
        LinkedList<BaseAssemblyNodeFactory> result = new LinkedList<BaseAssemblyNodeFactory>();
        TreeMap<Integer, List<BaseAssemblyNodeFactory>> nodesPerLevel = new TreeMap<Integer, List<BaseAssemblyNodeFactory>>();
        BaseAssemblyNodeFactory.recursiveAggregateEnter(topNode, nodesPerLevel, 1);
        if (nodesPerLevel.isEmpty()) {
            throw new IllegalStateException("Empty collection for nodes per level");
        }
        for (int i = deepLevel = nodesPerLevel.lastKey().intValue(); i >= 1; --i) {
            List<BaseAssemblyNodeFactory> list = nodesPerLevel.get(i);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    private static void recursiveAggregateEnter(BaseAssemblyNodeFactory currentNode, Map<Integer, List<BaseAssemblyNodeFactory>> nodesPerLevel, int currentLevel) {
        for (BaseAssemblyNodeFactory node : currentNode.childNodes) {
            BaseAssemblyNodeFactory.recursiveAggregateEnter(node, nodesPerLevel, currentLevel + 1);
        }
        List<BaseAssemblyNodeFactory> aggregates = nodesPerLevel.get(currentLevel);
        if (aggregates == null) {
            aggregates = new LinkedList<BaseAssemblyNodeFactory>();
            nodesPerLevel.put(currentLevel, aggregates);
        }
        aggregates.add(currentNode);
    }
}

