/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableVisitor;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.strategy.QueryStrategy;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerStreamToWinImpl
implements JoinSetComposer {
    private final boolean allowInitIndex;
    private final EventTable[][] repositories;
    private final int streamNumber;
    private final QueryStrategy queryStrategy;
    private final boolean isResetSelfJoinRepositories;
    private final boolean[] selfJoinRepositoryResets;
    private Set<MultiKeyArrayOfKeys<EventBean>> emptyResults = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();
    private Set<MultiKeyArrayOfKeys<EventBean>> newResults = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();

    public JoinSetComposerStreamToWinImpl(boolean allowInitIndex, Map<TableLookupIndexReqKey, EventTable>[] repositories, boolean isPureSelfJoin, int streamNumber, QueryStrategy queryStrategy, boolean[] selfJoinRepositoryResets) {
        this.allowInitIndex = allowInitIndex;
        this.repositories = JoinSetComposerUtil.toArray(repositories);
        this.streamNumber = streamNumber;
        this.queryStrategy = queryStrategy;
        this.selfJoinRepositoryResets = selfJoinRepositoryResets;
        if (isPureSelfJoin) {
            this.isResetSelfJoinRepositories = true;
            Arrays.fill(selfJoinRepositoryResets, true);
        } else {
            boolean flag = false;
            for (boolean selfJoinRepositoryReset : selfJoinRepositoryResets) {
                flag |= selfJoinRepositoryReset;
            }
            this.isResetSelfJoinRepositories = flag;
        }
    }

    @Override
    public boolean allowsInit() {
        return this.allowInitIndex;
    }

    @Override
    public void init(EventBean[][] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.allowInitIndex) {
            throw new IllegalStateException("Initialization by events not supported");
        }
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null || i == this.streamNumber) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i], exprEvaluatorContext);
            }
        }
    }

    @Override
    public void destroy() {
        for (EventTable[] repository : this.repositories) {
            if (repository == null) continue;
            for (EventTable table : repository) {
                table.destroy();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int j;
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qJoinCompositionStreamToWin();
        this.newResults.clear();
        for (int stream = 0; stream < newDataPerStream.length; ++stream) {
            if (stream == this.streamNumber) continue;
            instrumentationCommon.qJoinCompositionStepUpdIndex(stream, newDataPerStream[stream], oldDataPerStream[stream]);
            for (j = 0; j < this.repositories[stream].length; ++j) {
                this.repositories[stream][j].addRemove(newDataPerStream[stream], oldDataPerStream[stream], exprEvaluatorContext);
            }
            instrumentationCommon.aJoinCompositionStepUpdIndex();
        }
        if (newDataPerStream[this.streamNumber] != null) {
            instrumentationCommon.qJoinCompositionQueryStrategy(true, this.streamNumber, newDataPerStream[this.streamNumber]);
            this.queryStrategy.lookup(newDataPerStream[this.streamNumber], this.newResults, exprEvaluatorContext);
            instrumentationCommon.aJoinCompositionQueryStrategy();
        }
        if (this.isResetSelfJoinRepositories) {
            for (int i = 0; i < this.selfJoinRepositoryResets.length; ++i) {
                if (!this.selfJoinRepositoryResets[i]) continue;
                for (j = 0; j < this.repositories[i].length; ++j) {
                    this.repositories[i][j].clear();
                }
            }
        }
        exprEvaluatorContext.getInstrumentationProvider().aJoinCompositionStreamToWin(this.newResults);
        return new UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>(this.newResults, this.emptyResults);
    }

    @Override
    public Set<MultiKeyArrayOfKeys<EventBean>> staticJoin() {
        throw new UnsupportedOperationException("Iteration over a unidirectional join is not supported");
    }

    @Override
    public void accept(EventTableVisitor visitor) {
        visitor.visit(this.repositories);
    }
}

