/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.unindexed.UnindexedEventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Set;

public class FullTableScanLookupStrategy
implements JoinExecTableLookupStrategy {
    private UnindexedEventTable eventIndex;

    public FullTableScanLookupStrategy(UnindexedEventTable eventIndex) {
        this.eventIndex = eventIndex;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qIndexJoinLookup(this, this.eventIndex);
        Set<EventBean> result = this.eventIndex.getEventSet();
        if (result.isEmpty()) {
            instrumentationCommon.aIndexJoinLookup(null, null);
            return null;
        }
        instrumentationCommon.aIndexJoinLookup(result, null);
        return result;
    }

    public UnindexedEventTable getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.FULLTABLESCAN;
    }
}

