/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.IndexedTableLookupPlanHashedOnlyFactory;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Set;

public class IndexedTableLookupStrategyHashedExpr
implements JoinExecTableLookupStrategy {
    private final IndexedTableLookupPlanHashedOnlyFactory factory;
    private final PropertyHashedEventTable index;
    private final EventBean[] eventsPerStream;

    public IndexedTableLookupStrategyHashedExpr(IndexedTableLookupPlanHashedOnlyFactory factory, PropertyHashedEventTable index, int numStreams) {
        this.factory = factory;
        this.index = index;
        this.eventsPerStream = new EventBean[numStreams + 1];
    }

    public PropertyHashedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qIndexJoinLookup(this, this.index);
        this.eventsPerStream[this.factory.getLookupStream()] = theEvent;
        Object key = this.factory.getExprEvaluator().evaluate(this.eventsPerStream, true, exprEvaluatorContext);
        Set<EventBean> result = this.index.lookup(key);
        instrumentationCommon.aIndexJoinLookup(result, key);
        return result;
    }

    public String toString() {
        return "IndexedTableLookupStrategySingleExpr evaluation index=(" + this.index + ')';
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.MULTIEXPR;
    }
}

