/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.lookup;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.lookup.AdvancedIndexIndexMultiKeyPart;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

public class IndexMultiKey {
    private final boolean unique;
    private final IndexedPropDesc[] hashIndexedProps;
    private final IndexedPropDesc[] rangeIndexedProps;
    private final AdvancedIndexIndexMultiKeyPart advancedIndexDesc;

    public IndexMultiKey(boolean unique, List<IndexedPropDesc> hashIndexedProps, List<IndexedPropDesc> rangeIndexedProps, AdvancedIndexIndexMultiKeyPart advancedIndexDesc) {
        this.unique = unique;
        this.hashIndexedProps = hashIndexedProps.toArray(new IndexedPropDesc[hashIndexedProps.size()]);
        this.rangeIndexedProps = rangeIndexedProps.toArray(new IndexedPropDesc[rangeIndexedProps.size()]);
        this.advancedIndexDesc = advancedIndexDesc;
    }

    public IndexMultiKey(boolean unique, IndexedPropDesc[] hashIndexedProps, IndexedPropDesc[] rangeIndexedProps, AdvancedIndexIndexMultiKeyPart advancedIndexDesc) {
        this.unique = unique;
        this.hashIndexedProps = hashIndexedProps;
        this.rangeIndexedProps = rangeIndexedProps;
        this.advancedIndexDesc = advancedIndexDesc;
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(IndexMultiKey.class, this.getClass(), (CodegenScope)classScope);
        CodegenExpression hashes = IndexedPropDesc.makeArray(this.hashIndexedProps);
        CodegenExpression ranges = IndexedPropDesc.makeArray(this.rangeIndexedProps);
        CodegenExpression advanced = this.advancedIndexDesc == null ? CodegenExpressionBuilder.constantNull() : this.advancedIndexDesc.codegenMake(parent, classScope);
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(IndexMultiKey.class, CodegenExpressionBuilder.constant(this.unique), hashes, ranges, advanced));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexedPropDesc[] getHashIndexedProps() {
        return this.hashIndexedProps;
    }

    public IndexedPropDesc[] getRangeIndexedProps() {
        return this.rangeIndexedProps;
    }

    public AdvancedIndexIndexMultiKeyPart getAdvancedIndexDesc() {
        return this.advancedIndexDesc;
    }

    public String toQueryPlan() {
        StringWriter writer = new StringWriter();
        writer.append(this.unique ? "unique " : "non-unique ");
        writer.append("hash={");
        IndexedPropDesc.toQueryPlan(writer, this.hashIndexedProps);
        writer.append("} btree={");
        IndexedPropDesc.toQueryPlan(writer, this.rangeIndexedProps);
        writer.append("} advanced={");
        writer.append(this.advancedIndexDesc == null ? "" : this.advancedIndexDesc.toQueryPlan());
        writer.append("}");
        return writer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMultiKey that = (IndexMultiKey)o;
        if (this.unique != that.unique) {
            return false;
        }
        if (!Arrays.equals(this.hashIndexedProps, that.hashIndexedProps)) {
            return false;
        }
        if (!Arrays.equals(this.rangeIndexedProps, that.rangeIndexedProps)) {
            return false;
        }
        if (this.advancedIndexDesc == null) {
            return that.advancedIndexDesc == null;
        }
        return that.advancedIndexDesc != null && this.advancedIndexDesc.equalsAdvancedIndex(that.advancedIndexDesc);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.hashIndexedProps);
        result = 31 * result + Arrays.hashCode(this.rangeIndexedProps);
        return result;
    }
}

