/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.querygraph;

import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryInKeywordSingleIdx;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWSingleIdx;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairRangeIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class QueryGraphValue {
    private List<QueryGraphValueDesc> items;

    public QueryGraphValue(List<QueryGraphValueDesc> items) {
        this.items = items;
    }

    public List<QueryGraphValueDesc> getItems() {
        return this.items;
    }

    public QueryGraphValuePairHashKeyIndex getHashKeyProps() {
        ArrayList<QueryGraphValueEntryHashKeyed> keys = new ArrayList<QueryGraphValueEntryHashKeyed>();
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryHashKeyed)) continue;
            QueryGraphValueEntryHashKeyed keyprop = (QueryGraphValueEntryHashKeyed)desc.getEntry();
            keys.add(keyprop);
            indexed.add(desc.getIndexExprs()[0]);
        }
        return new QueryGraphValuePairHashKeyIndex(indexed.toArray(new String[indexed.size()]), keys);
    }

    public QueryGraphValuePairRangeIndex getRangeProps() {
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        ArrayList<QueryGraphValueEntryRange> keys = new ArrayList<QueryGraphValueEntryRange>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryRange)) continue;
            QueryGraphValueEntryRange keyprop = (QueryGraphValueEntryRange)desc.getEntry();
            keys.add(keyprop);
            indexed.add(desc.getIndexExprs()[0]);
        }
        return new QueryGraphValuePairRangeIndex(indexed.toArray(new String[indexed.size()]), keys);
    }

    public QueryGraphValuePairInKWSingleIdx getInKeywordSingles() {
        ArrayList<String> indexedProps = new ArrayList<String>();
        ArrayList<QueryGraphValueEntryInKeywordSingleIdx> single = new ArrayList<QueryGraphValueEntryInKeywordSingleIdx>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryInKeywordSingleIdx)) continue;
            QueryGraphValueEntryInKeywordSingleIdx keyprop = (QueryGraphValueEntryInKeywordSingleIdx)desc.getEntry();
            single.add(keyprop);
            indexedProps.add(desc.getIndexExprs()[0]);
        }
        return new QueryGraphValuePairInKWSingleIdx(indexedProps.toArray(new String[indexedProps.size()]), single);
    }
}

