/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.querygraph;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeEnum;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeUtil;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValue;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueDescForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomKeyForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomOperationForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeExpr;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeProp;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryInKeywordMultiIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryInKeywordSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeInForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOpForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairHashKeyIndexForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairRangeIndexForge;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class QueryGraphValueForge {
    private List<QueryGraphValueDescForge> items = new ArrayList<QueryGraphValueDescForge>();

    public boolean isEmptyNotNavigable() {
        return this.items.isEmpty();
    }

    public List<QueryGraphValueDescForge> getItems() {
        return this.items;
    }

    public boolean addStrictCompare(String keyProperty, ExprIdentNode keyPropNode, ExprIdentNode indexPropertyIdent) {
        QueryGraphValueEntryHashKeyedForgeExpr expr;
        QueryGraphValueDescForge value = this.findIdentEntry(indexPropertyIdent);
        if (value != null && value.getEntry() instanceof QueryGraphValueEntryHashKeyedForgeExpr && (expr = (QueryGraphValueEntryHashKeyedForgeExpr)value.getEntry()).isConstant()) {
            return false;
        }
        if (value != null && value.getEntry() instanceof QueryGraphValueEntryHashKeyedForgeProp) {
            return false;
        }
        this.items.add(new QueryGraphValueDescForge(new ExprNode[]{indexPropertyIdent}, new QueryGraphValueEntryHashKeyedForgeProp(keyPropNode, keyProperty, keyPropNode.getExprEvaluatorIdent().getGetter())));
        return true;
    }

    public void addRange(QueryGraphRangeEnum rangeType, ExprNode propertyStart, ExprNode propertyEnd, ExprIdentNode propertyValueIdent) {
        if (!rangeType.isRange()) {
            throw new IllegalArgumentException("Expected range type, received " + (Object)((Object)rangeType));
        }
        if (this.findIdentEntry(propertyValueIdent) != null) {
            return;
        }
        this.items.add(new QueryGraphValueDescForge(new ExprNode[]{propertyValueIdent}, new QueryGraphValueEntryRangeInForge(rangeType, propertyStart, propertyEnd, true)));
    }

    public void addRelOp(ExprNode propertyKey, QueryGraphRangeEnum op, ExprIdentNode propertyValueIdent, boolean isBetweenOrIn) {
        QueryGraphValueDescForge existing = this.findIdentEntry(propertyValueIdent);
        if (existing == null) {
            this.items.add(new QueryGraphValueDescForge(new ExprNode[]{propertyValueIdent}, new QueryGraphValueEntryRangeRelOpForge(op, propertyKey, isBetweenOrIn)));
            return;
        }
        if (!(existing.getEntry() instanceof QueryGraphValueEntryRangeRelOpForge)) {
            return;
        }
        QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)existing.getEntry();
        QueryGraphRangeConsolidateDesc opsDesc = QueryGraphRangeUtil.getCanConsolidate(op, relOp.getType());
        if (opsDesc != null) {
            ExprNode start = !opsDesc.isReverse() ? relOp.getExpression() : propertyKey;
            ExprNode end = !opsDesc.isReverse() ? propertyKey : relOp.getExpression();
            this.items.remove(existing);
            this.addRange(opsDesc.getType(), start, end, propertyValueIdent);
        }
    }

    public void addUnkeyedExpr(ExprIdentNode indexedPropIdent, ExprNode exprNodeNoIdent) {
        this.items.add(new QueryGraphValueDescForge(new ExprNode[]{indexedPropIdent}, new QueryGraphValueEntryHashKeyedForgeExpr(exprNodeNoIdent, false)));
    }

    public void addKeyedExpr(ExprIdentNode indexedPropIdent, ExprNode exprNodeNoIdent) {
        this.items.add(new QueryGraphValueDescForge(new ExprNode[]{indexedPropIdent}, new QueryGraphValueEntryHashKeyedForgeExpr(exprNodeNoIdent, true)));
    }

    public QueryGraphValuePairHashKeyIndexForge getHashKeyProps() {
        ArrayList<QueryGraphValueEntryHashKeyedForge> keys = new ArrayList<QueryGraphValueEntryHashKeyedForge>();
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryHashKeyedForge)) continue;
            QueryGraphValueEntryHashKeyedForge keyprop = (QueryGraphValueEntryHashKeyedForge)desc.getEntry();
            keys.add(keyprop);
            indexed.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        String[] strictKeys = new String[indexed.size()];
        int count = 0;
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryHashKeyedForge)) continue;
            if (desc.getEntry() instanceof QueryGraphValueEntryHashKeyedForgeProp) {
                QueryGraphValueEntryHashKeyedForgeProp keyprop = (QueryGraphValueEntryHashKeyedForgeProp)desc.getEntry();
                strictKeys[count] = keyprop.getKeyProperty();
            }
            ++count;
        }
        return new QueryGraphValuePairHashKeyIndexForge(indexed.toArray(new String[indexed.size()]), keys, strictKeys);
    }

    public QueryGraphValuePairRangeIndexForge getRangeProps() {
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        ArrayList<QueryGraphValueEntryRangeForge> keys = new ArrayList<QueryGraphValueEntryRangeForge>();
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryRangeForge)) continue;
            QueryGraphValueEntryRangeForge keyprop = (QueryGraphValueEntryRangeForge)desc.getEntry();
            keys.add(keyprop);
            indexed.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        return new QueryGraphValuePairRangeIndexForge(indexed.toArray(new String[indexed.size()]), keys);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("QueryGraphValue ");
        String delimiter = "";
        for (QueryGraphValueDescForge desc : this.items) {
            writer.append(delimiter);
            writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceAsList(desc.getIndexExprs()));
            writer.append(": ");
            writer.append(desc.getEntry().toString());
            delimiter = ", ";
        }
        return writer.toString();
    }

    public void addInKeywordMultiIdx(ExprNode testPropExpr, ExprNode[] setProps) {
        this.items.add(new QueryGraphValueDescForge(setProps, new QueryGraphValueEntryInKeywordMultiIdxForge(testPropExpr)));
    }

    public void addInKeywordSingleIdx(ExprNode testPropIdent, ExprNode[] setPropExpr) {
        ExprNode[] indexExpressions = new ExprNode[]{testPropIdent};
        QueryGraphValueDescForge found = this.findEntry(indexExpressions);
        ExprNode[] setExpressions = setPropExpr;
        if (found != null && found.getEntry() instanceof QueryGraphValueEntryInKeywordSingleIdxForge) {
            QueryGraphValueEntryInKeywordSingleIdxForge existing = (QueryGraphValueEntryInKeywordSingleIdxForge)found.getEntry();
            setExpressions = (ExprNode[])CollectionUtil.addArrays(existing.getKeyExprs(), setPropExpr);
            this.items.remove(found);
        }
        this.items.add(new QueryGraphValueDescForge(new ExprNode[]{testPropIdent}, new QueryGraphValueEntryInKeywordSingleIdxForge(setExpressions)));
    }

    public QueryGraphValuePairInKWSingleIdxForge getInKeywordSingles() {
        ArrayList<String> indexedProps = new ArrayList<String>();
        ArrayList<QueryGraphValueEntryInKeywordSingleIdxForge> single = new ArrayList<QueryGraphValueEntryInKeywordSingleIdxForge>();
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryInKeywordSingleIdxForge)) continue;
            QueryGraphValueEntryInKeywordSingleIdxForge keyprop = (QueryGraphValueEntryInKeywordSingleIdxForge)desc.getEntry();
            single.add(keyprop);
            indexedProps.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        return new QueryGraphValuePairInKWSingleIdxForge(indexedProps.toArray(new String[indexedProps.size()]), single);
    }

    public List<QueryGraphValuePairInKWMultiIdx> getInKeywordMulti() {
        ArrayList<QueryGraphValuePairInKWMultiIdx> multi = new ArrayList<QueryGraphValuePairInKWMultiIdx>();
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryInKeywordMultiIdxForge)) continue;
            QueryGraphValueEntryInKeywordMultiIdxForge keyprop = (QueryGraphValueEntryInKeywordMultiIdxForge)desc.getEntry();
            multi.add(new QueryGraphValuePairInKWMultiIdx(desc.getIndexExprs(), keyprop));
        }
        return multi;
    }

    public void addCustom(ExprNode[] indexExpressions, String operationName, int expressionPosition, ExprNode expression) {
        QueryGraphValueEntryCustomForge found = null;
        for (QueryGraphValueDescForge desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryCustomForge) || !ExprNodeUtilityCompare.deepEquals(desc.getIndexExprs(), indexExpressions, true)) continue;
            found = (QueryGraphValueEntryCustomForge)desc.getEntry();
            break;
        }
        if (found == null) {
            found = new QueryGraphValueEntryCustomForge();
            this.items.add(new QueryGraphValueDescForge(indexExpressions, found));
        }
        QueryGraphValueEntryCustomKeyForge key = new QueryGraphValueEntryCustomKeyForge(operationName, indexExpressions);
        QueryGraphValueEntryCustomOperationForge op = found.getOperations().get(key);
        if (op == null) {
            op = new QueryGraphValueEntryCustomOperationForge();
            found.getOperations().put(key, op);
        }
        op.getPositionalExpressions().put(expressionPosition, expression);
    }

    private QueryGraphValueDescForge findIdentEntry(ExprIdentNode search) {
        for (QueryGraphValueDescForge desc : this.items) {
            if (desc.getIndexExprs().length > 1 || !(desc.getIndexExprs()[0] instanceof ExprIdentNode)) continue;
            ExprIdentNode other = (ExprIdentNode)desc.getIndexExprs()[0];
            if (!search.getResolvedPropertyName().equals(other.getResolvedPropertyName())) continue;
            return desc;
        }
        return null;
    }

    private QueryGraphValueDescForge findEntry(ExprNode[] search) {
        for (QueryGraphValueDescForge desc : this.items) {
            if (!ExprNodeUtilityCompare.deepEquals(search, desc.getIndexExprs(), true)) continue;
            return desc;
        }
        return null;
    }

    private String getSingleIdentNodeProp(ExprNode[] indexExprs) {
        if (indexExprs.length != 1) {
            throw new IllegalStateException("Incorrect number of index expressions");
        }
        ExprIdentNode identNode = (ExprIdentNode)indexExprs[0];
        return identNode.getResolvedPropertyName();
    }

    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(QueryGraphValue.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(List.class, "items", CodegenExpressionBuilder.newInstance(ArrayList.class, CodegenExpressionBuilder.constant(this.items.size())));
        for (int i = 0; i < this.items.size(); ++i) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("items"), "add", this.items.get(i).make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(QueryGraphValue.class, CodegenExpressionBuilder.ref("items")));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

