/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeExpr;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeProp;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeInForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOpForge;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;
import java.util.Map;

public class CoercionUtil {
    private static final Class[] NULL_ARRAY = new Class[0];

    public static CoercionDesc getCoercionTypesRange(EventType[] typesPerStream, int indexedStream, String[] indexedProp, List<QueryGraphValueEntryRangeForge> rangeEntries) {
        if (rangeEntries.isEmpty()) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        Class[] coercionTypes = new Class[rangeEntries.size()];
        boolean mustCoerce = false;
        for (int i = 0; i < rangeEntries.size(); ++i) {
            Class coercionType;
            QueryGraphValueEntryRangeForge entry = rangeEntries.get(i);
            String indexed = indexedProp[i];
            Class valuePropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyType(indexed));
            if (entry.getType().isRange()) {
                QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)entry;
                coercionType = CoercionUtil.getCoercionTypeRangeIn(valuePropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
            } else {
                QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)entry;
                coercionType = CoercionUtil.getCoercionType(valuePropType, relOp.getExpression().getForge().getEvaluationType());
            }
            if (coercionType == null) {
                coercionTypes[i] = valuePropType;
                continue;
            }
            mustCoerce = true;
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static CoercionDesc getCoercionTypesHash(EventType[] typesPerStream, int lookupStream, int indexedStream, List<QueryGraphValueEntryHashKeyedForge> keyProps, String[] indexProps) {
        if (indexProps.length == 0 && keyProps.size() == 0) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        if (indexProps.length != keyProps.size()) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        Class[] coercionTypes = new Class[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < keyProps.size(); ++i) {
            Class indexedPropType;
            Class keyPropType;
            if (keyProps.get(i) instanceof QueryGraphValueEntryHashKeyedForgeExpr) {
                QueryGraphValueEntryHashKeyedForgeExpr hashExpr = (QueryGraphValueEntryHashKeyedForgeExpr)keyProps.get(i);
                keyPropType = hashExpr.getKeyExpr().getForge().getEvaluationType();
            } else {
                QueryGraphValueEntryHashKeyedForgeProp hashKeyProp = (QueryGraphValueEntryHashKeyedForgeProp)keyProps.get(i);
                keyPropType = JavaClassHelper.getBoxedType(typesPerStream[lookupStream].getPropertyType(hashKeyProp.getKeyProperty()));
            }
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static Class getCoercionTypeRange(EventType indexedType, String indexedProp, SubordPropRangeKeyForge rangeKey) {
        QueryGraphValueEntryRangeForge desc = rangeKey.getRangeInfo();
        if (desc.getType().isRange()) {
            QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)desc;
            return CoercionUtil.getCoercionTypeRangeIn(indexedType.getPropertyType(indexedProp), rangeIn.getExprStart(), rangeIn.getExprEnd());
        }
        QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)desc;
        return CoercionUtil.getCoercionType(indexedType.getPropertyType(indexedProp), relOp.getExpression().getForge().getEvaluationType());
    }

    public static CoercionDesc getCoercionTypesRange(EventType viewableEventType, Map<String, SubordPropRangeKeyForge> rangeProps, EventType[] typesPerStream) {
        if (rangeProps.isEmpty()) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        Class[] coercionTypes = new Class[rangeProps.size()];
        boolean mustCoerce = false;
        int count = 0;
        for (Map.Entry<String, SubordPropRangeKeyForge> entry : rangeProps.entrySet()) {
            Class coercionType;
            SubordPropRangeKeyForge subQRange = entry.getValue();
            QueryGraphValueEntryRangeForge rangeDesc = entry.getValue().getRangeInfo();
            Class valuePropType = JavaClassHelper.getBoxedType(viewableEventType.getPropertyType(entry.getKey()));
            if (rangeDesc.getType().isRange()) {
                QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)rangeDesc;
                coercionType = CoercionUtil.getCoercionTypeRangeIn(valuePropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
            } else {
                QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)rangeDesc;
                coercionType = CoercionUtil.getCoercionType(valuePropType, relOp.getExpression().getForge().getEvaluationType());
            }
            if (coercionType == null) {
                coercionTypes[count++] = valuePropType;
                continue;
            }
            mustCoerce = true;
            coercionTypes[count++] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    private static Class getCoercionType(Class valuePropType, Class keyPropTypeExpr) {
        Class coercionType = null;
        Class keyPropType = JavaClassHelper.getBoxedType(keyPropTypeExpr);
        if (valuePropType != keyPropType) {
            coercionType = JavaClassHelper.getCompareToCoercionType(valuePropType, keyPropType);
        }
        return coercionType;
    }

    public static CoercionDesc getCoercionTypesHash(EventType viewableEventType, String[] indexProps, List<SubordPropHashKeyForge> hashKeys) {
        if (indexProps.length == 0 && hashKeys.size() == 0) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        if (indexProps.length != hashKeys.size()) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        Class[] coercionTypes = new Class[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < hashKeys.size(); ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(hashKeys.get(i).getHashKey().getKeyExpr().getForge().getEvaluationType());
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(viewableEventType.getPropertyType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static Class getCoercionTypeRangeIn(Class valuePropType, ExprNode exprStart, ExprNode exprEnd) {
        Class coercionType = null;
        Class startPropType = JavaClassHelper.getBoxedType(exprStart.getForge().getEvaluationType());
        Class endPropType = JavaClassHelper.getBoxedType(exprEnd.getForge().getEvaluationType());
        if (valuePropType != startPropType) {
            coercionType = JavaClassHelper.getCompareToCoercionType(valuePropType, startPropType);
        }
        if (valuePropType != endPropType) {
            coercionType = JavaClassHelper.getCompareToCoercionType(coercionType, endPropType);
        }
        return coercionType;
    }
}

