/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.exec.outer.LookupInstructionExec;
import com.espertech.esper.common.internal.epl.join.exec.outer.LookupInstructionExecNode;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplanouter.LookupInstructionPlan;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class LookupInstructionQueryPlanNode
extends QueryPlanNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final LookupInstructionPlan[] lookupInstructions;
    private final boolean[] requiredPerStream;
    private final BaseAssemblyNodeFactory[] assemblyInstructionFactories;

    public LookupInstructionQueryPlanNode(int rootStream, String rootStreamName, int numStreams, boolean[] requiredPerStream, LookupInstructionPlan[] lookupInstructions, BaseAssemblyNodeFactory[] assemblyInstructionFactories) {
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.lookupInstructions = lookupInstructions;
        this.numStreams = numStreams;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructionFactories = assemblyInstructionFactories;
    }

    @Override
    public ExecNode makeExec(AgentInstanceContext agentInstanceContext, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, VirtualDWView[] viewExternal, Lock[] tableSecondaryIndexLocks) {
        LookupInstructionExec[] execs = new LookupInstructionExec[this.lookupInstructions.length];
        int count = 0;
        for (LookupInstructionPlan instruction : this.lookupInstructions) {
            LookupInstructionExec exec;
            execs[count] = exec = instruction.makeExec(agentInstanceContext, indexesPerStream, streamTypes, streamViews, viewExternal);
            ++count;
        }
        return new LookupInstructionExecNode(this.rootStream, this.rootStreamName, this.numStreams, execs, this.requiredPerStream, this.assemblyInstructionFactories);
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public LookupInstructionPlan[] getLookupInstructions() {
        return this.lookupInstructions;
    }
}

