/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeableUtil;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.join.queryplan.NestedIterationNode;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanNodeForgeVisitor;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class NestedIterationNodeForge
extends QueryPlanNodeForge {
    private final LinkedList<QueryPlanNodeForge> childNodes;
    private final int[] nestingOrder;

    public NestedIterationNodeForge(int[] nestingOrder) {
        this.nestingOrder = nestingOrder;
        this.childNodes = new LinkedList();
        if (nestingOrder.length == 0) {
            throw new IllegalArgumentException("Invalid empty nesting order");
        }
    }

    public final void addChildNode(QueryPlanNodeForge childNode) {
        this.childNodes.add(childNode);
    }

    public final LinkedList<QueryPlanNodeForge> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (QueryPlanNodeForge child : this.childNodes) {
            child.addIndexes(usedIndexes);
        }
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("NestedIterationNode with nesting order " + Arrays.toString(this.nestingOrder));
        indentWriter.incrIndent();
        for (QueryPlanNodeForge child : this.childNodes) {
            child.print(indentWriter);
        }
        indentWriter.decrIndent();
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression childNodeArray = CodegenMakeableUtil.makeArray((String)"childNodes", QueryPlanNode.class, (CodegenMakeable[])this.childNodes.toArray(new QueryPlanNodeForge[this.childNodes.size()]), this.getClass(), (CodegenMethodScope)parent, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope);
        return CodegenExpressionBuilder.newInstance(NestedIterationNode.class, childNodeArray, CodegenExpressionBuilder.constant(this.nestingOrder));
    }

    @Override
    public void accept(QueryPlanNodeForgeVisitor visitor) {
        visitor.visit(this);
        for (QueryPlanNodeForge child : this.childNodes) {
            child.accept(visitor);
        }
    }
}

