/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanbuild;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.NumberSetPermutationEnumeration;
import com.espertech.esper.common.internal.collection.NumberSetShiftGroupEnumeration;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalStreamIndexListForge;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalViewableDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeHistoricalDesc;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.CompositeTableLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.FullTableScanLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.FullTableScanUniquePerKeyLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.InKeywordTableLookupPlanMultiIdxForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.InKeywordTableLookupPlanSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.IndexedTableLookupPlanHashedOnlyForge;
import com.espertech.esper.common.internal.epl.join.indexlookupplan.SortedTableLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryInKeywordSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairHashKeyIndexForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairRangeIndexForge;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.HistoricalDataPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.NestedIterationNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForgeDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForgeDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeNoOpForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlanDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanIndexBuilder;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanNodeForgeVisitor;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexEntryBase;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexUtil;
import com.espertech.esper.common.internal.epl.lookupplansubord.IndexKeyInfo;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryPlannerUtil;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.util.DependencyGraph;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NStreamQueryPlanBuilder {
    private static final Logger log = LoggerFactory.getLogger(NStreamQueryPlanBuilder.class);

    protected static QueryPlanForgeDesc build(QueryGraphForge queryGraph, EventType[] typesPerStream, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, final HistoricalStreamIndexListForge[] historicalStreamIndexLists, boolean hasForceNestedIter, String[][][] indexedStreamsUniqueProps, TableMetaData[] tablesPerStream, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, final StatementRawInfo raw, final SerdeCompileTimeResolver serdeResolver) {
        if (log.isDebugEnabled()) {
            log.debug(".build filterQueryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        final ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        QueryPlanIndexForge[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph, typesPerStream, indexedStreamsUniqueProps);
        if (log.isDebugEnabled()) {
            log.debug(".build Index build completed, indexes=" + QueryPlanIndexForge.print(indexSpecs));
        }
        if (historicalViewableDesc.isHasHistorical()) {
            for (int i = 0; i < historicalViewableDesc.getHistorical().length; ++i) {
                if (!historicalViewableDesc.getHistorical()[i]) continue;
                indexSpecs[i] = null;
            }
        }
        QueryPlanNodeForge[] planNodeSpecs = new QueryPlanNodeForge[numStreams];
        int worstDepth = Integer.MAX_VALUE;
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            if (historicalViewableDesc.getHistorical()[streamNo] && dependencyGraph.hasDependency(streamNo)) {
                planNodeSpecs[streamNo] = new QueryPlanNodeNoOpForge();
                continue;
            }
            BestChainResult bestChainResult = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph, dependencyGraph);
            int[] bestChain = bestChainResult.getChain();
            if (log.isDebugEnabled()) {
                log.debug(".build For stream " + streamNo + " bestChain=" + Arrays.toString(bestChain));
            }
            if (bestChainResult.depth < worstDepth) {
                worstDepth = bestChainResult.depth;
            }
            QueryPlanNodeForgeDesc planDesc = NStreamQueryPlanBuilder.createStreamPlan(streamNo, bestChain, queryGraph, indexSpecs, typesPerStream, historicalViewableDesc.getHistorical(), historicalStreamIndexLists, tablesPerStream, streamJoinAnalysisResult, raw, serdeResolver);
            planNodeSpecs[streamNo] = planDesc.getForge();
            additionalForgeables.addAll(planDesc.getAdditionalForgeables());
            if (!log.isDebugEnabled()) continue;
            log.debug(".build spec=" + planNodeSpecs[streamNo]);
        }
        if (worstDepth < numStreams - 1 && !hasForceNestedIter) {
            return null;
        }
        for (int i = 0; i < numStreams; ++i) {
            QueryPlanNodeForge plan = planNodeSpecs[i];
            QueryPlanNodeForgeVisitor visitor = new QueryPlanNodeForgeVisitor(){

                @Override
                public void visit(QueryPlanNodeForge node) {
                    if (node instanceof HistoricalDataPlanNodeForge) {
                        HistoricalDataPlanNodeForge historical = (HistoricalDataPlanNodeForge)node;
                        JoinSetComposerPrototypeHistoricalDesc desc = historicalStreamIndexLists[historical.getStreamNum()].getStrategy(historical.getLookupStreamNum(), raw, serdeResolver);
                        historical.setPollResultIndexingStrategy(desc.getIndexingForge());
                        historical.setHistoricalIndexLookupStrategy(desc.getLookupForge());
                        additionalForgeables.addAll(desc.getAdditionalForgeables());
                    }
                }
            };
            plan.accept(visitor);
        }
        QueryPlanForge forge = new QueryPlanForge(indexSpecs, planNodeSpecs);
        return new QueryPlanForgeDesc(forge, additionalForgeables);
    }

    protected static QueryPlanNodeForgeDesc createStreamPlan(int lookupStream, int[] bestChain, QueryGraphForge queryGraph, QueryPlanIndexForge[] indexSpecsPerStream, EventType[] typesPerStream, boolean[] isHistorical, HistoricalStreamIndexListForge[] historicalStreamIndexLists, TableMetaData[] tablesPerStream, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        NestedIterationNodeForge nestedIterNode = new NestedIterationNodeForge(bestChain);
        int currentLookupStream = lookupStream;
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        for (int i = 0; i < bestChain.length; ++i) {
            QueryPlanNodeForge node;
            int indexedStream = bestChain[i];
            if (isHistorical[indexedStream]) {
                if (historicalStreamIndexLists[indexedStream] == null) {
                    historicalStreamIndexLists[indexedStream] = new HistoricalStreamIndexListForge(indexedStream, typesPerStream, queryGraph);
                }
                historicalStreamIndexLists[indexedStream].addIndex(currentLookupStream);
                node = new HistoricalDataPlanNodeForge(indexedStream, lookupStream, currentLookupStream, typesPerStream.length, null);
            } else {
                TableLookupPlanDesc tableLookupPlan = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, currentLookupStream, indexedStream, streamJoinAnalysisResult.isVirtualDW(indexedStream), indexSpecsPerStream[indexedStream], typesPerStream, tablesPerStream[indexedStream], raw, serdeResolver);
                node = new TableLookupNodeForge(tableLookupPlan.getForge());
                additionalForgeables.addAll(tableLookupPlan.getAdditionalForgeables());
            }
            nestedIterNode.addChildNode(node);
            currentLookupStream = bestChain[i];
        }
        return new QueryPlanNodeForgeDesc(nestedIterNode, additionalForgeables);
    }

    public static TableLookupPlanDesc createLookupPlan(QueryGraphForge queryGraph, int currentLookupStream, int indexedStream, boolean indexedStreamIsVDW, QueryPlanIndexForge indexSpecs, EventType[] typesPerStream, TableMetaData indexedStreamTableMeta, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        MultiKeyClassRef tableLookupMultiKey;
        TableLookupIndexReqKey indexNum;
        QueryGraphValueForge queryGraphValue = queryGraph.getGraphValue(currentLookupStream, indexedStream);
        QueryGraphValuePairHashKeyIndexForge hashKeyProps = queryGraphValue.getHashKeyProps();
        List<QueryGraphValueEntryHashKeyedForge> hashPropsKeys = hashKeyProps.getKeys();
        Object[] hashIndexProps = hashKeyProps.getIndexed();
        QueryGraphValuePairRangeIndexForge rangeProps = queryGraphValue.getRangeProps();
        List<QueryGraphValueEntryRangeForge> rangePropsKeys = rangeProps.getKeys();
        Object[] rangeIndexProps = rangeProps.getIndexed();
        Pair<TableLookupIndexReqKey, int[]> pairIndexHashRewrite = indexSpecs.getIndexNum((String[])hashIndexProps, (String[])rangeIndexProps);
        TableLookupIndexReqKey tableLookupIndexReqKey = indexNum = pairIndexHashRewrite == null ? null : pairIndexHashRewrite.getFirst();
        if (pairIndexHashRewrite != null && pairIndexHashRewrite.getSecond() != null) {
            int[] indexes = pairIndexHashRewrite.getSecond();
            String[] newHashIndexProps = new String[indexes.length];
            ArrayList<QueryGraphValueEntryHashKeyedForge> newHashKeys = new ArrayList<QueryGraphValueEntryHashKeyedForge>();
            for (int i = 0; i < indexes.length; ++i) {
                newHashIndexProps[i] = hashIndexProps[indexes[i]];
                newHashKeys.add(hashPropsKeys.get(indexes[i]));
            }
            hashIndexProps = newHashIndexProps;
            hashPropsKeys = newHashKeys;
            rangeIndexProps = new String[]{};
            rangePropsKeys = Collections.emptyList();
        }
        if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) {
            List<QueryGraphValuePairInKWMultiIdx> multis;
            TableLookupPlanForge forge;
            QueryGraphValuePairInKWSingleIdxForge singles = queryGraphValue.getInKeywordSingles();
            if (!singles.getKey().isEmpty()) {
                QueryGraphValueEntryInKeywordSingleIdxForge single = null;
                indexNum = null;
                if (indexedStreamTableMeta != null) {
                    String[] indexes = singles.getIndexed();
                    int count = 0;
                    for (String index : indexes) {
                        Pair<IndexMultiKey, EventTableIndexEntryBase> indexPairFound = EventTableIndexUtil.findIndexBestAvailable(indexedStreamTableMeta.getIndexMetadata().getIndexes(), Collections.singleton(index), Collections.emptySet(), null);
                        if (indexPairFound != null) {
                            indexNum = new TableLookupIndexReqKey(indexPairFound.getSecond().getOptionalIndexName(), indexPairFound.getSecond().getOptionalIndexModuleName(), indexedStreamTableMeta.getTableName());
                            single = singles.getKey().get(count);
                        }
                        ++count;
                    }
                } else {
                    single = singles.getKey().get(0);
                    Pair<TableLookupIndexReqKey, int[]> pairIndex = indexSpecs.getIndexNum(new String[]{singles.getIndexed()[0]}, new String[0]);
                    indexNum = pairIndex.getFirst();
                }
                if (indexNum != null) {
                    forge = new InKeywordTableLookupPlanSingleIdxForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNum, single.getKeyExprs());
                    return new TableLookupPlanDesc(forge, Collections.emptyList());
                }
            }
            if (!(multis = queryGraphValue.getInKeywordMulti()).isEmpty()) {
                if (indexedStreamTableMeta != null) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexedStreamTableMeta);
                }
                QueryGraphValuePairInKWMultiIdx multi = multis.get(0);
                TableLookupIndexReqKey[] indexNameArray = new TableLookupIndexReqKey[multi.getIndexed().length];
                boolean foundAll = true;
                for (int i = 0; i < multi.getIndexed().length; ++i) {
                    ExprIdentNode identNode = (ExprIdentNode)multi.getIndexed()[i];
                    Pair<TableLookupIndexReqKey, int[]> pairIndex = indexSpecs.getIndexNum(new String[]{identNode.getResolvedPropertyName()}, new String[0]);
                    if (pairIndex == null) {
                        foundAll = false;
                        continue;
                    }
                    indexNameArray[i] = pairIndex.getFirst();
                }
                if (foundAll) {
                    InKeywordTableLookupPlanMultiIdxForge forge2 = new InKeywordTableLookupPlanMultiIdxForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNameArray, multi.getKey().getKeyExpr());
                    return new TableLookupPlanDesc(forge2, Collections.emptyList());
                }
            }
            if (indexedStreamTableMeta != null) {
                return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexedStreamTableMeta);
            }
            if (indexNum == null) {
                indexNum = new TableLookupIndexReqKey(indexSpecs.addIndex(new String[0], new Class[0], typesPerStream[indexedStream]), null);
            }
            forge = new FullTableScanLookupPlanForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNum);
            return new TableLookupPlanDesc(forge, Collections.emptyList());
        }
        if (indexNum == null) {
            throw new IllegalStateException("Failed to query plan as index for " + Arrays.toString(hashIndexProps) + " and " + Arrays.toString(rangeIndexProps) + " in the index specification");
        }
        if (indexedStreamTableMeta != null) {
            Pair<IndexMultiKey, EventTableIndexEntryBase> indexPairFound = EventTableIndexUtil.findIndexBestAvailable(indexedStreamTableMeta.getIndexMetadata().getIndexes(), NStreamQueryPlanBuilder.toSet((String[])hashIndexProps), NStreamQueryPlanBuilder.toSet((String[])rangeIndexProps), null);
            if (indexPairFound != null) {
                IndexKeyInfo indexKeyInfo = SubordinateQueryPlannerUtil.compileIndexKeyInfo(indexPairFound.getFirst(), (String[])hashIndexProps, NStreamQueryPlanBuilder.getHashKeyFuncsAsSubProp(hashPropsKeys), (String[])rangeIndexProps, NStreamQueryPlanBuilder.getRangeFuncsAsSubProp(rangePropsKeys));
                if (indexKeyInfo.getOrderedKeyCoercionTypes().isCoerce() || indexKeyInfo.getOrderedRangeCoercionTypes().isCoerce()) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexedStreamTableMeta);
                }
                hashPropsKeys = NStreamQueryPlanBuilder.toHashKeyFuncs(indexKeyInfo.getOrderedHashDesc());
                hashIndexProps = IndexedPropDesc.getIndexProperties(indexPairFound.getFirst().getHashIndexedProps());
                rangePropsKeys = NStreamQueryPlanBuilder.toRangeKeyFuncs(indexKeyInfo.getOrderedRangeDesc());
                rangeIndexProps = IndexedPropDesc.getIndexProperties(indexPairFound.getFirst().getRangeIndexedProps());
                indexNum = new TableLookupIndexReqKey(indexPairFound.getSecond().getOptionalIndexName(), indexPairFound.getSecond().getOptionalIndexModuleName(), indexedStreamTableMeta.getTableName());
                if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexedStreamTableMeta);
                }
            } else {
                return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexedStreamTableMeta);
            }
        }
        if (hashIndexProps.length > 0 && rangeIndexProps.length == 0) {
            CoercionDesc coercionTypes = CoercionUtil.getCoercionTypesHash(typesPerStream, currentLookupStream, indexedStream, hashPropsKeys, (String[])hashIndexProps);
            if (coercionTypes.isCoerce()) {
                Class[] existCoercionTypes = indexSpecs.getCoercionTypes((String[])hashIndexProps);
                if (existCoercionTypes != null) {
                    for (int i = 0; i < existCoercionTypes.length; ++i) {
                        coercionTypes.getCoercionTypes()[i] = JavaClassHelper.getCompareToCoercionType(existCoercionTypes[i], coercionTypes.getCoercionTypes()[i]);
                    }
                }
                if (!indexSpecs.getItems().isEmpty()) {
                    indexSpecs.setCoercionTypes((String[])hashIndexProps, coercionTypes.getCoercionTypes());
                }
            }
            Class[] coercionTypesArray = coercionTypes.getCoercionTypes();
            tableLookupMultiKey = null;
            List<StmtClassForgeableFactory> additionalForgeables = Collections.emptyList();
            if (indexNum.getTableName() != null) {
                MultiKeyPlan tableMultiKeyPlan = MultiKeyPlanner.planMultiKey(coercionTypesArray, true, raw, serdeResolver);
                tableLookupMultiKey = tableMultiKeyPlan.getClassRef();
                additionalForgeables = tableMultiKeyPlan.getMultiKeyForgeables();
            }
            IndexedTableLookupPlanHashedOnlyForge forge = new IndexedTableLookupPlanHashedOnlyForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNum, hashPropsKeys.toArray(new QueryGraphValueEntryHashKeyedForge[hashPropsKeys.size()]), indexSpecs, coercionTypesArray, tableLookupMultiKey);
            return new TableLookupPlanDesc(forge, additionalForgeables);
        }
        CoercionDesc coercionTypesRange = CoercionUtil.getCoercionTypesRange(typesPerStream, indexedStream, (String[])rangeIndexProps, rangePropsKeys);
        CoercionDesc coercionTypesHash = CoercionUtil.getCoercionTypesHash(typesPerStream, currentLookupStream, indexedStream, hashPropsKeys, (String[])hashIndexProps);
        if (hashIndexProps.length == 0 && rangeIndexProps.length == 1) {
            QueryGraphValueEntryRangeForge range = rangePropsKeys.get(0);
            Class coercionType = null;
            if (coercionTypesRange.isCoerce()) {
                coercionType = coercionTypesRange.getCoercionTypes()[0];
            }
            SortedTableLookupPlanForge forge = new SortedTableLookupPlanForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNum, range, coercionType);
            return new TableLookupPlanDesc(forge, Collections.emptyList());
        }
        tableLookupMultiKey = null;
        List<StmtClassForgeableFactory> additionalForgeables = Collections.emptyList();
        if (indexNum.getTableName() != null) {
            MultiKeyPlan tableMultiKeyPlan = MultiKeyPlanner.planMultiKey(coercionTypesHash.getCoercionTypes(), true, raw, serdeResolver);
            tableLookupMultiKey = tableMultiKeyPlan.getClassRef();
            additionalForgeables = tableMultiKeyPlan.getMultiKeyForgeables();
        }
        CompositeTableLookupPlanForge forge = new CompositeTableLookupPlanForge(currentLookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexNum, hashPropsKeys, coercionTypesHash.getCoercionTypes(), rangePropsKeys, coercionTypesRange.getCoercionTypes(), indexSpecs, tableLookupMultiKey);
        return new TableLookupPlanDesc(forge, additionalForgeables);
    }

    protected static BestChainResult computeBestPath(int lookupStream, QueryGraphForge queryGraph, DependencyGraph dependencyGraph) {
        int[] defNestingorder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(queryGraph.getNumStreams(), lookupStream);
        Enumeration<int[]> streamEnum = defNestingorder.length < 6 ? new NumberSetPermutationEnumeration(defNestingorder) : new NumberSetShiftGroupEnumeration(defNestingorder);
        int[] bestPermutation = null;
        int bestDepth = -1;
        while (streamEnum.hasMoreElements()) {
            boolean pass;
            int[] permutation = streamEnum.nextElement();
            if (dependencyGraph != null && !(pass = NStreamQueryPlanBuilder.isDependencySatisfied(lookupStream, permutation, dependencyGraph))) continue;
            int permutationDepth = NStreamQueryPlanBuilder.computeNavigableDepth(lookupStream, permutation, queryGraph);
            if (permutationDepth > bestDepth) {
                bestPermutation = permutation;
                bestDepth = permutationDepth;
            }
            if (permutationDepth != queryGraph.getNumStreams() - 1) continue;
            break;
        }
        return new BestChainResult(bestDepth, bestPermutation);
    }

    protected static boolean isDependencySatisfied(int lookupStream, int[] permutation, DependencyGraph dependencyGraph) {
        for (Map.Entry<Integer, SortedSet<Integer>> entry : dependencyGraph.getDependencies().entrySet()) {
            int target = entry.getKey();
            int positionTarget = NStreamQueryPlanBuilder.positionOf(target, lookupStream, permutation);
            if (positionTarget == -1) {
                throw new IllegalArgumentException("Target dependency not found in permutation for target " + target + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
            }
            Iterator iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                int dependency = (Integer)iterator.next();
                int positonDep = NStreamQueryPlanBuilder.positionOf(dependency, lookupStream, permutation);
                if (positonDep == -1) {
                    throw new IllegalArgumentException("Dependency not found in permutation for dependency " + dependency + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
                }
                if (positonDep <= positionTarget) continue;
                return false;
            }
        }
        return true;
    }

    private static int positionOf(int stream, int lookupStream, int[] permutation) {
        if (stream == lookupStream) {
            return 0;
        }
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != stream) continue;
            return i + 1;
        }
        return -1;
    }

    protected static int computeNavigableDepth(int lookupStream, int[] nextStreams, QueryGraphForge queryGraph) {
        int nextStream;
        boolean navigable;
        int currentStream = lookupStream;
        int currentDepth = 0;
        for (int i = 0; i < nextStreams.length && (navigable = queryGraph.isNavigableAtAll(currentStream, nextStream = nextStreams[i])); ++i) {
            currentStream = nextStream;
            ++currentDepth;
        }
        return currentDepth;
    }

    protected static int[] buildDefaultNestingOrder(int numStreams, int forStream) {
        int[] nestingOrder = new int[numStreams - 1];
        int count = 0;
        for (int i = 0; i < numStreams; ++i) {
            if (i == forStream) continue;
            nestingOrder[count++] = i;
        }
        return nestingOrder;
    }

    private static List<QueryGraphValueEntryRangeForge> toRangeKeyFuncs(List<SubordPropRangeKeyForge> orderedRangeDesc) {
        ArrayList<QueryGraphValueEntryRangeForge> result = new ArrayList<QueryGraphValueEntryRangeForge>();
        for (SubordPropRangeKeyForge key : orderedRangeDesc) {
            result.add(key.getRangeInfo());
        }
        return result;
    }

    private static List<QueryGraphValueEntryHashKeyedForge> toHashKeyFuncs(List<SubordPropHashKeyForge> orderedHashProperties) {
        ArrayList<QueryGraphValueEntryHashKeyedForge> result = new ArrayList<QueryGraphValueEntryHashKeyedForge>();
        for (SubordPropHashKeyForge key : orderedHashProperties) {
            result.add(key.getHashKey());
        }
        return result;
    }

    private static TableLookupPlanDesc getFullTableScanTable(int lookupStream, int indexedStream, boolean indexedStreamIsVDW, EventType[] typesPerStream, TableMetaData indexedStreamTableMeta) {
        TableLookupIndexReqKey indexName = new TableLookupIndexReqKey(indexedStreamTableMeta.getTableName(), indexedStreamTableMeta.getTableModuleName(), indexedStreamTableMeta.getTableName());
        FullTableScanUniquePerKeyLookupPlanForge forge = new FullTableScanUniquePerKeyLookupPlanForge(lookupStream, indexedStream, indexedStreamIsVDW, typesPerStream, indexName);
        return new TableLookupPlanDesc(forge, Collections.emptyList());
    }

    private static SubordPropRangeKeyForge[] getRangeFuncsAsSubProp(List<QueryGraphValueEntryRangeForge> funcs) {
        SubordPropRangeKeyForge[] keys = new SubordPropRangeKeyForge[funcs.size()];
        for (int i = 0; i < funcs.size(); ++i) {
            QueryGraphValueEntryRangeForge func = funcs.get(i);
            keys[i] = new SubordPropRangeKeyForge(func, func.getExpressions()[0].getForge().getEvaluationType());
        }
        return keys;
    }

    private static SubordPropHashKeyForge[] getHashKeyFuncsAsSubProp(List<QueryGraphValueEntryHashKeyedForge> funcs) {
        SubordPropHashKeyForge[] keys = new SubordPropHashKeyForge[funcs.size()];
        for (int i = 0; i < funcs.size(); ++i) {
            keys[i] = new SubordPropHashKeyForge(funcs.get(i), null, null);
        }
        return keys;
    }

    private static Set<String> toSet(String[] strings) {
        return new LinkedHashSet<String>(Arrays.asList(strings));
    }

    public static class BestChainResult {
        private int depth;
        private int[] chain;

        public BestChainResult(int depth, int[] chain) {
            this.depth = depth;
            this.chain = chain;
        }

        public int getDepth() {
            return this.depth;
        }

        public int[] getChain() {
            return this.chain;
        }

        public String toString() {
            return "depth=" + this.depth + " chain=" + Arrays.toString(this.chain);
        }
    }
}

