/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.rep;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.join.rep.Node;
import com.espertech.esper.common.internal.epl.join.rep.NodeCursorIterator;
import com.espertech.esper.common.internal.epl.join.rep.Repository;
import com.espertech.esper.common.internal.epl.join.rep.SingleCursorIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RepositoryImpl
implements Repository {
    private final int rootStream;
    private final EventBean rootEvent;
    private final int numStreams;
    private List<Node>[] nodesPerStream;
    private static Iterator<Cursor> emptyCursorIterator = new SingleCursorIterator(null);

    public RepositoryImpl(int rootStream, EventBean rootEvent, int numStreams) {
        this.rootStream = rootStream;
        this.rootEvent = rootEvent;
        this.numStreams = numStreams;
    }

    @Override
    public Iterator<Cursor> getCursors(int lookupFromStream) {
        if (lookupFromStream == this.rootStream) {
            Cursor cursor = new Cursor(this.rootEvent, this.rootStream, null);
            return new SingleCursorIterator(cursor);
        }
        List<Node> nodeList = this.nodesPerStream[lookupFromStream];
        if (nodeList == null) {
            return emptyCursorIterator;
        }
        return new NodeCursorIterator(lookupFromStream, nodeList.iterator());
    }

    @Override
    public void addResult(Cursor cursor, Set<EventBean> lookupResults, int resultStream) {
        if (lookupResults.isEmpty()) {
            throw new IllegalArgumentException("Attempting to add zero results");
        }
        Node parentNode = cursor.getNode();
        if (parentNode == null) {
            List<Node> nodes;
            Node leafNode = new Node(resultStream);
            leafNode.setEvents(lookupResults);
            if (this.nodesPerStream == null) {
                this.nodesPerStream = new List[this.numStreams];
            }
            if ((nodes = this.nodesPerStream[resultStream]) == null) {
                this.nodesPerStream[resultStream] = nodes = new LinkedList<Node>();
            }
            leafNode.setParentEvent(this.rootEvent);
            nodes.add(leafNode);
            return;
        }
        Node leafNode = new Node(resultStream);
        leafNode.setEvents(lookupResults);
        leafNode.setParent(cursor.getNode());
        leafNode.setParentEvent(cursor.getTheEvent());
        List<Node> nodes = this.nodesPerStream[resultStream];
        if (nodes == null) {
            this.nodesPerStream[resultStream] = nodes = new LinkedList<Node>();
        }
        nodes.add(leafNode);
    }

    public List<Node>[] getNodesPerStream() {
        return this.nodesPerStream;
    }
}

