/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookup;

import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.common.internal.epl.lookup.AdvancedIndexIndexMultiKeyPart;
import java.io.StringWriter;

public class AdvancedIndexDescWExpr {
    private final String indexTypeName;
    private final ExprNode[] indexedExpressions;

    public AdvancedIndexDescWExpr(String indexTypeName, ExprNode[] indexedExpressions) {
        this.indexTypeName = indexTypeName;
        this.indexedExpressions = indexedExpressions;
    }

    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    public ExprNode[] getIndexedExpressions() {
        return this.indexedExpressions;
    }

    public String toQueryPlan() {
        if (this.indexedExpressions.length == 0) {
            return this.indexTypeName;
        }
        StringWriter writer = new StringWriter();
        writer.append(this.indexTypeName);
        writer.append("(");
        ExprNodeUtilityPrint.toExpressionStringMinPrecedenceAsList(this.indexedExpressions, writer);
        writer.append(")");
        return writer.toString();
    }

    public AdvancedIndexIndexMultiKeyPart getAdvancedIndexDescRuntime() {
        String[] indexExpressionTexts = new String[this.indexedExpressions.length];
        String[] indexedProperties = new String[indexExpressionTexts.length];
        for (int i = 0; i < this.indexedExpressions.length; ++i) {
            indexExpressionTexts[i] = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.indexedExpressions[i]);
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            this.indexedExpressions[i].accept(visitor);
            if (visitor.getExprProperties().size() != 1) {
                throw new IllegalStateException("Failed to find indexed property");
            }
            indexedProperties[i] = visitor.getExprProperties().iterator().next().getSecond();
        }
        return new AdvancedIndexIndexMultiKeyPart(this.indexTypeName, indexExpressionTexts, indexedProperties);
    }
}

