/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import java.util.ArrayDeque;
import java.util.Collection;

public class SubordFullTableScanLookupStrategyLocking
implements SubordTableLookupStrategy {
    private final Iterable<EventBean> contents;
    private final StatementAgentInstanceLock statementLock;

    public SubordFullTableScanLookupStrategyLocking(Iterable<EventBean> contents, StatementAgentInstanceLock statementLock) {
        this.contents = contents;
        this.statementLock = statementLock;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        if (context.getInstrumentationProvider().activated()) {
            context.getInstrumentationProvider().qIndexSubordLookup(this, null, null);
            Collection<EventBean> result = this.lookupInternal();
            context.getInstrumentationProvider().aIndexSubordLookup(result, null);
            return result;
        }
        return this.lookupInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EventBean> lookupInternal() {
        this.statementLock.acquireReadLock();
        try {
            ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
            for (EventBean eventBean : this.contents) {
                result.add(eventBean);
            }
            ArrayDeque<EventBean> arrayDeque = result;
            return arrayDeque;
        }
        finally {
            this.statementLock.releaseReadLock();
        }
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return LookupStrategyDesc.SCAN;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

