/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookupplansubord;

import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadataEntry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EventTableIndexMetadata {
    private final Map<IndexMultiKey, EventTableIndexMetadataEntry> indexes;

    public EventTableIndexMetadata() {
        this.indexes = new HashMap<IndexMultiKey, EventTableIndexMetadataEntry>();
    }

    private EventTableIndexMetadata(Map<IndexMultiKey, EventTableIndexMetadataEntry> indexes) {
        this.indexes = indexes;
    }

    public void addIndexExplicit(boolean isPrimary, IndexMultiKey indexMultiKey, String explicitIndexName, String explicitIndexModuleName, QueryPlanIndexItem explicitIndexDesc, String deploymentId) throws ExprValidationException {
        if (this.getIndexByName(explicitIndexName) != null) {
            throw new ExprValidationException("An index by name '" + explicitIndexName + "' already exists");
        }
        if (this.indexes.containsKey(indexMultiKey)) {
            throw new ExprValidationException("An index for the same columns already exists");
        }
        EventTableIndexMetadataEntry entry = new EventTableIndexMetadataEntry(explicitIndexName, explicitIndexModuleName, isPrimary, explicitIndexDesc, explicitIndexName, explicitIndexModuleName, deploymentId);
        entry.addReferringDeployment(deploymentId);
        this.indexes.put(indexMultiKey, entry);
    }

    public void addIndexNonExplicit(IndexMultiKey indexMultiKey, String deploymentId, QueryPlanIndexItem queryPlanIndexItem) {
        if (indexMultiKey == null) {
            throw new IllegalArgumentException("Null index multikey");
        }
        if (this.indexes.containsKey(indexMultiKey)) {
            return;
        }
        EventTableIndexMetadataEntry entry = new EventTableIndexMetadataEntry(null, null, false, queryPlanIndexItem, null, null, deploymentId);
        entry.addReferringDeployment(deploymentId);
        this.indexes.put(indexMultiKey, entry);
    }

    public Map<IndexMultiKey, EventTableIndexMetadataEntry> getIndexes() {
        return this.indexes;
    }

    public void removeIndex(IndexMultiKey imk) {
        this.indexes.remove(imk);
    }

    public boolean removeIndexReference(IndexMultiKey index, String referringDeploymentId) {
        if (index == null) {
            throw new IllegalArgumentException("Null index multikey");
        }
        EventTableIndexMetadataEntry entry = this.indexes.get(index);
        if (entry == null) {
            return false;
        }
        return entry.removeReferringStatement(referringDeploymentId);
    }

    public void addIndexReference(String indexName, String deploymentId) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return;
        }
        entry.getValue().addReferringDeployment(deploymentId);
    }

    public void removeIndexReference(String indexName, String deploymentId) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return;
        }
        entry.getValue().removeReferringStatement(deploymentId);
    }

    public void addIndexReference(IndexMultiKey indexMultiKey, String deploymentId) {
        EventTableIndexMetadataEntry entry = this.indexes.get(indexMultiKey);
        if (entry == null) {
            return;
        }
        entry.addReferringDeployment(deploymentId);
    }

    public EventTableIndexMetadataEntry getIndexEntryByName(String indexName) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public IndexMultiKey getIndexByName(String indexName) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    public String getIndexDeploymentId(String indexName) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return null;
        }
        return entry.getValue().getDeploymentId();
    }

    public Collection<String> getRemoveRefIndexesDereferenced(String deploymentId) {
        ArrayDeque<String> indexNamesDerrefd = null;
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            boolean last = entry.getValue().removeReferringStatement(deploymentId);
            if (!last) continue;
            if (indexNamesDerrefd == null) {
                indexNamesDerrefd = new ArrayDeque<String>(2);
            }
            indexNamesDerrefd.add(entry.getValue().getOptionalIndexName());
        }
        if (indexNamesDerrefd == null) {
            return Collections.emptyList();
        }
        for (String name : indexNamesDerrefd) {
            this.removeIndex(this.getIndexByName(name));
        }
        return indexNamesDerrefd;
    }

    private Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> findIndex(String indexName) {
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null || !entry.getValue().getOptionalIndexName().equals(indexName)) continue;
            return entry;
        }
        return null;
    }

    public String[][] getUniqueIndexProps() {
        ArrayDeque<String[]> uniques = new ArrayDeque<String[]>(2);
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            if (!entry.getKey().isUnique()) continue;
            String[] props = new String[entry.getKey().getHashIndexedProps().length];
            for (int i = 0; i < entry.getKey().getHashIndexedProps().length; ++i) {
                props[i] = entry.getKey().getHashIndexedProps()[i].getIndexPropName();
            }
            uniques.add(props);
        }
        return (String[][])uniques.toArray((T[])new String[uniques.size()][]);
    }

    public EventTableIndexMetadata copy() {
        return new EventTableIndexMetadata(new HashMap<IndexMultiKey, EventTableIndexMetadataEntry>(this.indexes));
    }
}

