/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookupplansubord;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableAndNamePair;
import com.espertech.esper.common.internal.epl.index.base.EventTableUtil;
import com.espertech.esper.common.internal.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexEntryBase;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepositoryEntry;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTableIndexRepository {
    private final List<EventTable> tables = new ArrayList<EventTable>();
    private final Map<IndexMultiKey, EventTableIndexRepositoryEntry> tableIndexesRefCount = new HashMap<IndexMultiKey, EventTableIndexRepositoryEntry>();
    private final HashMap<String, EventTable> explicitIndexes = new HashMap();
    private final EventTableIndexMetadata eventTableIndexMetadata;

    public EventTableIndexRepository(EventTableIndexMetadata eventTableIndexMetadata) {
        this.eventTableIndexMetadata = eventTableIndexMetadata;
    }

    public EventTableIndexMetadata getEventTableIndexMetadata() {
        return this.eventTableIndexMetadata;
    }

    public Pair<IndexMultiKey, EventTableAndNamePair> addExplicitIndexOrReuse(QueryPlanIndexItem desc, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName, String indexModuleName, AgentInstanceContext agentInstanceContext, DataInputOutputSerde<Object> optionalValueSerde) {
        IndexMultiKey indexMultiKey = desc.toIndexMultiKey();
        if (desc.getHashPropsAsList().isEmpty() && desc.getBtreePropsAsList().isEmpty() && desc.getAdvancedIndexProvisionDesc() == null) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        IndexMultiKey indexPropKeyMatch = EventTableIndexUtil.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), indexMultiKey);
        if (indexPropKeyMatch != null) {
            EventTableIndexRepositoryEntry refTablePair = this.tableIndexesRefCount.get(indexPropKeyMatch);
            return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKeyMatch, new EventTableAndNamePair(refTablePair.getTable(), refTablePair.getOptionalIndexName()));
        }
        return this.addIndex(desc, prefilledEvents, indexedType, indexName, indexModuleName, false, agentInstanceContext, optionalValueSerde);
    }

    public void addIndex(IndexMultiKey indexMultiKey, EventTableIndexRepositoryEntry entry) {
        this.tableIndexesRefCount.put(indexMultiKey, entry);
        this.tables.add(entry.getTable());
    }

    public List<EventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        for (EventTable table : this.tables) {
            table.destroy();
        }
        this.tables.clear();
        this.tableIndexesRefCount.clear();
    }

    public Pair<IndexMultiKey, EventTableAndNamePair> findTable(Set<String> keyPropertyNames, Set<String> rangePropertyNames, List<IndexHintInstruction> optionalIndexHintInstructions) {
        Pair<IndexMultiKey, EventTableIndexEntryBase> pair = EventTableIndexUtil.findIndexBestAvailable(this.tableIndexesRefCount, keyPropertyNames, rangePropertyNames, optionalIndexHintInstructions);
        if (pair == null) {
            return null;
        }
        EventTable tableFound = ((EventTableIndexRepositoryEntry)pair.getSecond()).getTable();
        return new Pair<IndexMultiKey, EventTableAndNamePair>(pair.getFirst(), new EventTableAndNamePair(tableFound, pair.getSecond().getOptionalIndexName()));
    }

    public IndexMultiKey[] getIndexDescriptors() {
        Set<IndexMultiKey> keySet = this.tableIndexesRefCount.keySet();
        return keySet.toArray(new IndexMultiKey[keySet.size()]);
    }

    public Map<IndexMultiKey, EventTableIndexRepositoryEntry> getTableIndexesRefCount() {
        return this.tableIndexesRefCount;
    }

    public void validateAddExplicitIndex(String explicitIndexName, String explicitIndexModuleName, QueryPlanIndexItem explicitIndexDesc, EventType eventType, Iterable<EventBean> dataWindowContents, AgentInstanceContext agentInstanceContext, boolean allowIndexExists, DataInputOutputSerde<Object> optionalValueSerde) throws ExprValidationException {
        if (this.explicitIndexes.containsKey(explicitIndexName)) {
            if (allowIndexExists) {
                return;
            }
            throw new ExprValidationException("Index by name '" + explicitIndexName + "' already exists");
        }
        this.addExplicitIndex(explicitIndexName, explicitIndexModuleName, explicitIndexDesc, eventType, dataWindowContents, agentInstanceContext, optionalValueSerde);
    }

    public void addExplicitIndex(String explicitIndexName, String explicitIndexModuleName, QueryPlanIndexItem desc, EventType eventType, Iterable<EventBean> dataWindowContents, AgentInstanceContext agentInstanceContext, DataInputOutputSerde<Object> optionalSerde) {
        Pair<IndexMultiKey, EventTableAndNamePair> pair = this.addExplicitIndexOrReuse(desc, dataWindowContents, eventType, explicitIndexName, explicitIndexModuleName, agentInstanceContext, optionalSerde);
        this.explicitIndexes.put(explicitIndexName, pair.getSecond().getEventTable());
    }

    public EventTable getExplicitIndexByName(String indexName) {
        return this.explicitIndexes.get(indexName);
    }

    public EventTable getIndexByDesc(IndexMultiKey indexKey) {
        EventTableIndexRepositoryEntry entry = this.tableIndexesRefCount.get(indexKey);
        if (entry == null) {
            return null;
        }
        return entry.getTable();
    }

    private Pair<IndexMultiKey, EventTableAndNamePair> addIndex(QueryPlanIndexItem indexItem, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName, String indexModuleName, boolean mustCoerce, AgentInstanceContext agentInstanceContext, DataInputOutputSerde<Object> optionalValueSerde) {
        IndexMultiKey indexPropKey = indexItem.toIndexMultiKey();
        EventTable table = EventTableUtil.buildIndex(agentInstanceContext, 0, indexItem, indexedType, true, indexItem.isUnique(), indexName, optionalValueSerde, false);
        try {
            EventBean[] events = new EventBean[1];
            Iterator<EventBean> iterator = prefilledEvents.iterator();
            while (iterator.hasNext()) {
                EventBean prefilledEvent;
                events[0] = prefilledEvent = iterator.next();
                table.add(events, (ExprEvaluatorContext)agentInstanceContext);
            }
        }
        catch (Throwable t) {
            table.destroy();
            throw t;
        }
        this.tables.add(table);
        this.tableIndexesRefCount.put(indexPropKey, new EventTableIndexRepositoryEntry(indexName, indexModuleName, table));
        return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKey, new EventTableAndNamePair(table, indexName));
    }

    public String[] getExplicitIndexNames() {
        Set<String> names = this.explicitIndexes.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void removeIndex(IndexMultiKey index) {
        EventTableIndexRepositoryEntry entry = this.tableIndexesRefCount.remove(index);
        if (entry != null) {
            this.tables.remove(entry.getTable());
            if (entry.getOptionalIndexName() != null) {
                this.explicitIndexes.remove(entry.getOptionalIndexName());
            }
            entry.getTable().destroy();
        }
    }

    public IndexMultiKey getIndexByName(String indexName) {
        for (Map.Entry<IndexMultiKey, EventTableIndexRepositoryEntry> entry : this.tableIndexesRefCount.entrySet()) {
            if (!entry.getValue().getOptionalIndexName().equals(indexName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void removeExplicitIndex(String indexName) {
        EventTable eventTable = this.explicitIndexes.remove(indexName);
        if (eventTable != null) {
            eventTable.destroy();
        }
    }
}

