/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.compile;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.util.CompileTimeRegistry;
import java.util.HashMap;
import java.util.Map;

public class NamedWindowCompileTimeRegistry
implements CompileTimeRegistry {
    private final Map<String, NamedWindowMetaData> namedWindows = new HashMap<String, NamedWindowMetaData>();

    public void newNamedWindow(NamedWindowMetaData detail) {
        EventType eventType = detail.getEventType();
        if (!eventType.getMetadata().getAccessModifier().isModuleProvidedAccessModifier()) {
            throw new IllegalStateException("Invalid visibility for named window");
        }
        String namedWindowName = detail.getEventType().getName();
        NamedWindowMetaData existing = this.namedWindows.get(namedWindowName);
        if (existing != null) {
            throw new IllegalStateException("Duplicate named window definition encountered");
        }
        this.namedWindows.put(namedWindowName, detail);
    }

    public boolean isNamedWindow(String namedWindowName) {
        return this.namedWindows.containsKey(namedWindowName);
    }

    public EventType getEventType(String namedWindowName) {
        return this.namedWindows.get(namedWindowName).getEventType();
    }

    public Map<String, NamedWindowMetaData> getNamedWindows() {
        return this.namedWindows;
    }
}

