/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.ContextRuntimeDescriptor;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerDesc;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootView;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailView;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowWDirectConsume;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import com.espertech.esper.common.internal.statement.resource.StatementResourceService;
import java.util.Map;

public class NamedWindowImpl
implements NamedWindowWDirectConsume {
    private final NamedWindowRootView rootView;
    private final NamedWindowTailView tailView;
    private final EventTableIndexMetadata eventTableIndexMetadataRepo;
    private StatementContext statementContext;

    public NamedWindowImpl(NamedWindowMetaData metadata, EPStatementInitServices services) {
        this.rootView = new NamedWindowRootView(metadata);
        this.eventTableIndexMetadataRepo = metadata.getIndexMetadata();
        this.tailView = services.getNamedWindowFactoryService().createNamedWindowTailView(metadata.getEventType(), metadata.isChildBatching(), services, metadata.getContextName());
    }

    @Override
    public String getName() {
        return this.rootView.getEventType().getName();
    }

    @Override
    public NamedWindowRootView getRootView() {
        return this.rootView;
    }

    @Override
    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    @Override
    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        if (this.rootView.getContextName() != null) {
            ContextRuntimeDescriptor contextDescriptor = consumerDesc.getAgentInstanceContext().getStatementContext().getContextRuntimeDescriptor();
            if (contextDescriptor != null && this.rootView.getContextName().equals(contextDescriptor.getContextName())) {
                StatementResourceHolder holder = this.statementContext.getStatementResourceService().getPartitioned(consumerDesc.getAgentInstanceContext().getAgentInstanceId());
                return holder.getNamedWindowInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
            }
            return this.tailView.addConsumerNoContext(consumerDesc);
        }
        StatementResourceService statementResourceService = this.statementContext.getStatementCPCacheService().getStatementResourceService();
        return statementResourceService.getResourcesUnpartitioned().getNamedWindowInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
    }

    @Override
    public NamedWindowInstance getNamedWindowInstance(AgentInstanceContext agentInstanceContext) {
        if (this.rootView.getContextName() == null) {
            return this.getNamedWindowInstanceNoContext();
        }
        if (agentInstanceContext.getStatementContext().getContextRuntimeDescriptor() == null) {
            return null;
        }
        if (this.rootView.getContextName().equals(agentInstanceContext.getStatementContext().getContextRuntimeDescriptor().getContextName())) {
            return this.getNamedWindowInstance(agentInstanceContext.getAgentInstanceId());
        }
        return null;
    }

    @Override
    public NamedWindowInstance getNamedWindowInstanceNoContext() {
        StatementResourceService statementResourceService = this.statementContext.getStatementCPCacheService().getStatementResourceService();
        StatementResourceHolder holder = statementResourceService.getUnpartitioned();
        return holder == null ? null : holder.getNamedWindowInstance();
    }

    @Override
    public NamedWindowInstance getNamedWindowInstance(int agentInstanceId) {
        StatementResourceService statementResourceService = this.statementContext.getStatementCPCacheService().getStatementResourceService();
        StatementResourceHolder holder = statementResourceService.getPartitioned(agentInstanceId);
        return holder == null ? null : holder.getNamedWindowInstance();
    }

    @Override
    public EventTableIndexMetadata getEventTableIndexMetadata() {
        return this.eventTableIndexMetadataRepo;
    }

    @Override
    public void removeAllInstanceIndexes(IndexMultiKey index) {
        StatementResourceService statementResourceService = this.statementContext.getStatementCPCacheService().getStatementResourceService();
        if (this.rootView.getContextName() == null) {
            StatementResourceHolder holder = statementResourceService.getUnpartitioned();
            if (holder != null && holder.getNamedWindowInstance() != null) {
                holder.getNamedWindowInstance().removeIndex(index);
            }
        } else {
            for (Map.Entry<Integer, StatementResourceHolder> entry : statementResourceService.getResourcesPartitioned().entrySet()) {
                if (entry.getValue().getNamedWindowInstance() == null) continue;
                entry.getValue().getNamedWindowInstance().removeIndex(index);
            }
        }
    }

    @Override
    public void removeIndexReferencesStmtMayRemoveIndex(IndexMultiKey imk, String referringDeploymentId, String referringStatementName) {
        boolean last = this.eventTableIndexMetadataRepo.removeIndexReference(imk, referringDeploymentId);
        if (last) {
            this.eventTableIndexMetadataRepo.removeIndex(imk);
            this.removeAllInstanceIndexes(imk);
        }
    }

    @Override
    public void validateAddIndex(String deloymentId, String statementName, String explicitIndexName, String explicitIndexModuleName, QueryPlanIndexItem explicitIndexDesc, IndexMultiKey imk) throws ExprValidationException {
        this.eventTableIndexMetadataRepo.addIndexExplicit(false, imk, explicitIndexName, explicitIndexModuleName, explicitIndexDesc, deloymentId);
    }

    @Override
    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    @Override
    public void setStatementContext(StatementContext statementContext) {
        this.statementContext = statementContext;
    }
}

