/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerCallback;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerDesc;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchFactory;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowDeltaData;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailViewBase;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowUtil;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NamedWindowTailViewImpl
extends NamedWindowTailViewBase {
    private volatile Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersNonContext;

    public NamedWindowTailViewImpl(EventType eventType, boolean isParentBatchWindow, EPStatementInitServices services) {
        super(eventType, isParentBatchWindow, services);
        this.consumersNonContext = NamedWindowUtil.createConsumerMap(this.isPrioritized);
    }

    public Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> getConsumersNonContext() {
        return this.consumersNonContext;
    }

    @Override
    public NamedWindowConsumerView addConsumerNoContext(NamedWindowConsumerDesc consumerDesc) {
        NamedWindowConsumerCallback consumerCallback = new NamedWindowConsumerCallback(){

            @Override
            public Iterator<EventBean> getIterator() {
                throw new UnsupportedOperationException("Iterator not supported on named windows that have a context attached and when that context is not the same as the consuming statement's context");
            }

            @Override
            public boolean isParentBatchWindow() {
                return NamedWindowTailViewImpl.this.isParentBatchWindow;
            }

            @Override
            public Collection<EventBean> snapshot(QueryGraph queryGraph, Annotation[] annotations) {
                return Collections.emptyList();
            }

            @Override
            public void stopped(NamedWindowConsumerView namedWindowConsumerView) {
                NamedWindowTailViewImpl.this.removeConsumerNoContext(namedWindowConsumerView);
            }
        };
        boolean audit = AuditEnum.STREAM.getAudit(consumerDesc.getAgentInstanceContext().getStatementContext().getAnnotations()) != null;
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(consumerDesc.getNamedWindowConsumerId(), consumerDesc.getFilterEvaluator(), consumerDesc.getOptPropertyEvaluator(), this.eventType, consumerCallback, consumerDesc.getAgentInstanceContext(), audit);
        List<NamedWindowConsumerView> viewsPerStatements = this.consumersNonContext.get(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle());
        if (viewsPerStatements == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.isPrioritized);
            newConsumers.putAll(this.consumersNonContext);
            newConsumers.put(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), viewsPerStatements);
            this.consumersNonContext = newConsumers;
        }
        viewsPerStatements.add(consumerView);
        return consumerView;
    }

    @Override
    public void removeConsumerNoContext(NamedWindowConsumerView namedWindowConsumerView) {
        EPStatementAgentInstanceHandle handleRemoved = null;
        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : this.consumersNonContext.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.isPrioritized);
            newConsumers.putAll(this.consumersNonContext);
            newConsumers.remove(handleRemoved);
            this.consumersNonContext = newConsumers;
        }
    }

    @Override
    public void addDispatches(NamedWindowConsumerLatchFactory latchFactory, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersInContext, NamedWindowDeltaData delta, AgentInstanceContext agentInstanceContext) {
        if (!consumersInContext.isEmpty()) {
            this.namedWindowDispatchService.addDispatch(latchFactory, delta, consumersInContext);
        }
        if (!this.consumersNonContext.isEmpty()) {
            this.namedWindowDispatchService.addDispatch(latchFactory, delta, this.consumersNonContext);
        }
    }

    @Override
    public NamedWindowConsumerLatchFactory makeLatchFactory() {
        return new NamedWindowConsumerLatchFactory(this.eventType.getName(), this.threadingConfig.isNamedWindowConsumerDispatchPreserveOrder(), this.threadingConfig.getNamedWindowConsumerDispatchTimeout(), this.threadingConfig.getNamedWindowConsumerDispatchLocking(), this.timeSourceService, true);
    }
}

