/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.path;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.Copyable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NamedWindowMetaData
implements Copyable<NamedWindowMetaData> {
    private final EventType eventType;
    private final String namedWindowModuleName;
    private final String contextName;
    private final String[] uniqueness;
    private final boolean isChildBatching;
    private final boolean isEnableIndexShare;
    private final EventType optionalEventTypeAs;
    private final boolean virtualDataWindow;
    private final EventTableIndexMetadata indexMetadata;

    public NamedWindowMetaData(EventType eventType, String namedWindowModuleName, String contextName, String[] uniqueness, boolean isChildBatching, boolean isEnableIndexShare, EventType optionalEventTypeAs, boolean virtualDataWindow) {
        this.eventType = eventType;
        this.namedWindowModuleName = namedWindowModuleName;
        this.contextName = contextName;
        this.uniqueness = uniqueness;
        this.isChildBatching = isChildBatching;
        this.isEnableIndexShare = isEnableIndexShare;
        this.optionalEventTypeAs = optionalEventTypeAs;
        this.indexMetadata = new EventTableIndexMetadata();
        this.virtualDataWindow = virtualDataWindow;
    }

    public NamedWindowMetaData(EventType eventType, String namedWindowModuleName, String contextName, String[] uniqueness, boolean isChildBatching, boolean isEnableIndexShare, EventType optionalEventTypeAs, boolean virtualDataWindow, EventTableIndexMetadata indexMetadata) {
        this.eventType = eventType;
        this.namedWindowModuleName = namedWindowModuleName;
        this.contextName = contextName;
        this.uniqueness = uniqueness;
        this.isChildBatching = isChildBatching;
        this.isEnableIndexShare = isEnableIndexShare;
        this.optionalEventTypeAs = optionalEventTypeAs;
        this.virtualDataWindow = virtualDataWindow;
        this.indexMetadata = indexMetadata;
    }

    @Override
    public NamedWindowMetaData copy() {
        return new NamedWindowMetaData(this.eventType, this.namedWindowModuleName, this.contextName, this.uniqueness, this.isChildBatching, this.isEnableIndexShare, this.optionalEventTypeAs, this.virtualDataWindow, this.indexMetadata.copy());
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String[] getUniqueness() {
        return this.uniqueness;
    }

    public EventTableIndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public CodegenExpression make(CodegenExpressionRef addInitSvc) {
        return CodegenExpressionBuilder.newInstance(NamedWindowMetaData.class, EventTypeUtility.resolveTypeCodegen(this.eventType, addInitSvc), CodegenExpressionBuilder.constant(this.namedWindowModuleName), CodegenExpressionBuilder.constant(this.contextName), CodegenExpressionBuilder.constant(this.uniqueness), CodegenExpressionBuilder.constant(this.isChildBatching), CodegenExpressionBuilder.constant(this.isEnableIndexShare), this.optionalEventTypeAs == null ? CodegenExpressionBuilder.constantNull() : EventTypeUtility.resolveTypeCodegen(this.optionalEventTypeAs, addInitSvc), CodegenExpressionBuilder.constant(this.virtualDataWindow));
    }

    public Set<String> getUniquenessAsSet() {
        if (this.uniqueness == null || this.uniqueness.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.uniqueness));
    }

    public String getContextName() {
        return this.contextName;
    }

    public void addIndex(String indexName, String indexModuleName, IndexMultiKey imk, QueryPlanIndexItem optionalQueryPlanIndexItem) throws ExprValidationException {
        this.indexMetadata.addIndexExplicit(false, imk, indexName, indexModuleName, optionalQueryPlanIndexItem, "");
    }

    public boolean isChildBatching() {
        return this.isChildBatching;
    }

    public boolean isEnableIndexShare() {
        return this.isEnableIndexShare;
    }

    public EventType getOptionalEventTypeAs() {
        return this.optionalEventTypeAs;
    }

    public boolean isVirtualDataWindow() {
        return this.virtualDataWindow;
    }

    public String getNamedWindowModuleName() {
        return this.namedWindowModuleName;
    }
}

