/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootViewInstance;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnSelectUtil;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnSelectViewFactory;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewNameWindowBase;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OnExprViewNamedWindowSelect
extends OnExprViewNameWindowBase {
    private final InfraOnSelectViewFactory parent;
    private final ResultSetProcessor resultSetProcessor;
    private final Set<MultiKeyArrayOfKeys<EventBean>> oldEvents = new HashSet<MultiKeyArrayOfKeys<EventBean>>();
    private final boolean audit;
    private final boolean isDelete;
    private final TableInstance tableInstanceInsertInto;

    public OnExprViewNamedWindowSelect(SubordWMatchExprLookupStrategy lookupStrategy, NamedWindowRootViewInstance rootView, AgentInstanceContext agentInstanceContext, InfraOnSelectViewFactory parent, ResultSetProcessor resultSetProcessor, boolean audit, boolean isDelete, TableInstance tableInstanceInsertInto) {
        super(lookupStrategy, rootView, agentInstanceContext);
        this.parent = parent;
        this.resultSetProcessor = resultSetProcessor;
        this.audit = audit;
        this.isDelete = isDelete;
        this.tableInstanceInsertInto = tableInstanceInsertInto;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        StatementResultService statementResultService;
        this.agentInstanceContext.getInstrumentationProvider().qInfraOnAction(OnTriggerType.ON_SELECT, triggerEvents, matchingEvents);
        this.resultSetProcessor.clear();
        Set<MultiKeyArrayOfKeys<EventBean>> newEvents = OnExprViewNamedWindowSelect.buildJoinResult(triggerEvents, matchingEvents);
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, this.oldEvents, false);
        EventBean[] newData = pair != null ? pair.getFirst() : null;
        newData = InfraOnSelectUtil.handleDistintAndInsert(newData, this.parent, this.agentInstanceContext, this.tableInstanceInsertInto, this.audit);
        if (newData != null && newData.length > 0 && this.child != null && ((statementResultService = this.agentInstanceContext.getStatementResultService()).isMakeNatural() || statementResultService.isMakeSynthetic())) {
            this.child.update(newData, null);
        }
        this.resultSetProcessor.clear();
        if (this.isDelete) {
            this.rootView.update(null, matchingEvents);
        }
        this.agentInstanceContext.getInstrumentationProvider().aInfraOnAction();
    }

    public static Set<MultiKeyArrayOfKeys<EventBean>> buildJoinResult(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        LinkedHashSet<MultiKeyArrayOfKeys<EventBean>> events = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();
        for (int i = 0; i < triggerEvents.length; ++i) {
            EventBean triggerEvent = triggerEvents[0];
            if (matchingEvents == null) continue;
            for (int j = 0; j < matchingEvents.length; ++j) {
                EventBean[] eventsPerStream = new EventBean[]{matchingEvents[j], triggerEvent};
                events.add(new MultiKeyArrayOfKeys<EventBean>(eventsPerStream));
            }
        }
        return events;
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }
}

