/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeMatch;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeViewFactory;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewTableBase;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewTableChangeHandler;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.List;

public class OnExprViewTableMerge
extends OnExprViewTableBase {
    private final InfraOnMergeViewFactory parent;

    public OnExprViewTableMerge(SubordWMatchExprLookupStrategy lookupStrategy, TableInstance tableInstance, AgentInstanceContext agentInstanceContext, InfraOnMergeViewFactory parent) {
        super(lookupStrategy, tableInstance, agentInstanceContext, parent.getOnMergeHelper().isRequiresTableWriteLock());
        this.parent = parent;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] eventBeanArray;
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qInfraOnAction(OnTriggerType.ON_MERGE, triggerEvents, matchingEvents);
        EventBean[] eventsPerStream = new EventBean[3];
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean postResultsToListeners = statementResultService.isMakeNatural() || statementResultService.isMakeSynthetic();
        OnExprViewTableChangeHandler changeHandlerRemoved = null;
        OnExprViewTableChangeHandler changeHandlerAdded = null;
        if (postResultsToListeners) {
            changeHandlerRemoved = new OnExprViewTableChangeHandler(this.tableInstance.getTable());
            changeHandlerAdded = new OnExprViewTableChangeHandler(this.tableInstance.getTable());
        }
        if (matchingEvents == null || matchingEvents.length == 0) {
            List<InfraOnMergeMatch> unmatched = this.parent.getOnMergeHelper().getUnmatched();
            eventBeanArray = triggerEvents;
            int n = eventBeanArray.length;
            for (int i = 0; i < n; ++i) {
                EventBean triggerEvent;
                eventsPerStream[1] = triggerEvent = eventBeanArray[i];
                instrumentationCommon.qInfraMergeWhenThens(false, triggerEvent, unmatched.size());
                int count = -1;
                for (InfraOnMergeMatch action : unmatched) {
                    instrumentationCommon.qInfraMergeWhenThenItem(false, ++count);
                    if (!action.isApplies(eventsPerStream, super.getExprEvaluatorContext())) {
                        instrumentationCommon.aInfraMergeWhenThenItem(false, false);
                        continue;
                    }
                    action.applyTable(null, eventsPerStream, this.tableInstance, changeHandlerAdded, changeHandlerRemoved, this.agentInstanceContext);
                    instrumentationCommon.aInfraMergeWhenThenItem(false, true);
                    break;
                }
                instrumentationCommon.aInfraMergeWhenThens(false);
            }
        } else {
            List<InfraOnMergeMatch> matched = this.parent.getOnMergeHelper().getMatched();
            eventBeanArray = triggerEvents;
            int n = eventBeanArray.length;
            for (int i = 0; i < n; ++i) {
                EventBean triggerEvent;
                eventsPerStream[1] = triggerEvent = eventBeanArray[i];
                instrumentationCommon.qInfraMergeWhenThens(true, triggerEvent, matched.size());
                EventBean[] eventBeanArray2 = matchingEvents;
                int n2 = eventBeanArray2.length;
                block3: for (int j = 0; j < n2; ++j) {
                    EventBean matchingEvent;
                    eventsPerStream[0] = matchingEvent = eventBeanArray2[j];
                    int count = -1;
                    for (InfraOnMergeMatch action : matched) {
                        instrumentationCommon.qInfraMergeWhenThenItem(true, ++count);
                        if (!action.isApplies(eventsPerStream, super.getExprEvaluatorContext())) {
                            instrumentationCommon.aInfraMergeWhenThenItem(true, false);
                            continue;
                        }
                        action.applyTable(matchingEvent, eventsPerStream, this.tableInstance, changeHandlerAdded, changeHandlerRemoved, this.agentInstanceContext);
                        instrumentationCommon.aInfraMergeWhenThenItem(true, true);
                        continue block3;
                    }
                }
                instrumentationCommon.aInfraMergeWhenThens(true);
            }
        }
        if (postResultsToListeners) {
            EventBean[] postedNew = changeHandlerAdded.getEvents();
            EventBean[] postedOld = changeHandlerRemoved.getEvents();
            if (postedNew != null || postedOld != null) {
                this.child.update(postedNew, postedOld);
            }
        }
        instrumentationCommon.aInfraOnAction();
    }
}

