/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnSelectUtil;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnSelectViewFactory;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewNamedWindowSelect;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewTableBase;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import java.util.Collections;
import java.util.Set;

public class OnExprViewTableSelect
extends OnExprViewTableBase {
    private final InfraOnSelectViewFactory parent;
    private final ResultSetProcessor resultSetProcessor;
    private final boolean audit;
    private final boolean deleteAndSelect;
    private final TableInstance tableInstanceInsertInto;

    public OnExprViewTableSelect(SubordWMatchExprLookupStrategy lookupStrategy, TableInstance tableInstance, AgentInstanceContext agentInstanceContext, ResultSetProcessor resultSetProcessor, InfraOnSelectViewFactory parent, boolean audit, boolean deleteAndSelect, TableInstance tableInstanceInsertInto) {
        super(lookupStrategy, tableInstance, agentInstanceContext, deleteAndSelect);
        this.parent = parent;
        this.resultSetProcessor = resultSetProcessor;
        this.audit = audit;
        this.deleteAndSelect = deleteAndSelect;
        this.tableInstanceInsertInto = tableInstanceInsertInto;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        StatementResultService statementResultService;
        this.agentInstanceContext.getInstrumentationProvider().qInfraOnAction(OnTriggerType.ON_SELECT, triggerEvents, matchingEvents);
        this.resultSetProcessor.clear();
        Set<MultiKeyArrayOfKeys<EventBean>> newEvents = OnExprViewNamedWindowSelect.buildJoinResult(triggerEvents, matchingEvents);
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, Collections.emptySet(), false);
        EventBean[] newData = pair != null ? pair.getFirst() : null;
        newData = InfraOnSelectUtil.handleDistintAndInsert(newData, this.parent, this.agentInstanceContext, this.tableInstanceInsertInto, this.audit);
        if (newData != null && newData.length > 0 && ((statementResultService = this.agentInstanceContext.getStatementResultService()).isMakeNatural() || statementResultService.isMakeSynthetic())) {
            this.child.update(newData, null);
        }
        this.resultSetProcessor.clear();
        if (this.deleteAndSelect) {
            for (EventBean event : matchingEvents) {
                this.tableInstance.deleteEvent(event);
            }
        }
        this.agentInstanceContext.getInstrumentationProvider().aInfraOnAction();
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return super.getEventType();
    }
}

