/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionCount;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionFactory;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;

public class OutputConditionCountFactory
implements OutputConditionFactory {
    protected final long eventRate;
    protected final Variable variable;

    public OutputConditionCountFactory(int eventRate, Variable variable) {
        if (eventRate < 1 && variable == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        this.eventRate = eventRate;
        this.variable = variable;
    }

    @Override
    public OutputCondition instantiateOutputCondition(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        VariableReader variableReader = null;
        if (this.variable != null) {
            variableReader = agentInstanceContext.getStatementContext().getVariableManagementService().getReader(this.variable.getDeploymentId(), this.variable.getMetaData().getVariableName(), agentInstanceContext.getAgentInstanceId());
        }
        return new OutputConditionCount(outputCallback, this.eventRate, variableReader);
    }

    public long getEventRate() {
        return this.eventRate;
    }

    public Object getVariable() {
        return this.variable;
    }
}

