/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionBase;
import com.espertech.esper.common.internal.schedule.ScheduleComputeHelper;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import com.espertech.esper.common.internal.schedule.SchedulingService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionCrontab
extends OutputConditionBase
implements OutputCondition {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "crontab";
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final ScheduleSpec scheduleSpec;
    private final long scheduleSlot;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionCrontab.class);

    public OutputConditionCrontab(OutputCallback outputCallback, AgentInstanceContext context, boolean isStartConditionOnCreation, ScheduleSpec scheduleSpec) {
        super(outputCallback);
        this.context = context;
        this.scheduleSpec = scheduleSpec;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartConditionOnCreation) {
            this.updateOutputCondition(0, 0);
        }
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " spec=" + this.scheduleSpec;
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                OutputConditionCrontab.this.context.getInstrumentationProvider().qOutputRateConditionScheduledEval();
                OutputConditionCrontab.this.context.getAuditProvider().scheduleFire(OutputConditionCrontab.this.context, ScheduleObjectType.outputratelimiting, OutputConditionCrontab.NAME_AUDITPROVIDER_SCHEDULE);
                OutputConditionCrontab.this.isCallbackScheduled = false;
                OutputConditionCrontab.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionCrontab.this.scheduleCallback();
                OutputConditionCrontab.this.context.getInstrumentationProvider().aOutputRateConditionScheduledEval();
            }
        };
        EPStatementHandleCallbackSchedule handle = new EPStatementHandleCallbackSchedule(this.context.getEpStatementAgentInstanceHandle(), callback);
        SchedulingService schedulingService = this.context.getStatementContext().getSchedulingService();
        ClasspathImportServiceRuntime classpathImportService = this.context.getStatementContext().getClasspathImportServiceRuntime();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.scheduleSpec, schedulingService.getTime(), classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus());
        this.context.getAuditProvider().scheduleAdd(nextScheduledTime, this.context, handle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
        schedulingService.add(nextScheduledTime, handle, this.scheduleSlot);
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }

    @Override
    public void stopOutputCondition() {
    }
}

