/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionFactory;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionFactory;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionFactoryForge;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployTimeResolver;
import com.espertech.esper.common.internal.epl.variable.core.VariableReadWritePackageForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import java.util.List;
import java.util.Map;

public class OutputConditionExpressionForge
implements OutputConditionFactoryForge,
ScheduleHandleCallbackProvider {
    private final ExprNode whenExpressionNodeEval;
    private final ExprNode andWhenTerminatedExpressionNodeEval;
    private final VariableReadWritePackageForge variableReadWritePackage;
    private final VariableReadWritePackageForge variableReadWritePackageAfterTerminated;
    private final Map<String, VariableMetaData> variableNames;
    protected final boolean isStartConditionOnCreation;
    private final boolean isUsingBuiltinProperties;
    private int scheduleCallbackId = -1;

    public OutputConditionExpressionForge(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, ExprNode andWhenTerminatedExpr, List<OnTriggerSetAssignment> afterTerminateAssignments, boolean isStartConditionOnCreation, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        this.whenExpressionNodeEval = whenExpressionNode;
        this.andWhenTerminatedExpressionNodeEval = andWhenTerminatedExpr;
        this.isStartConditionOnCreation = isStartConditionOnCreation;
        ExprNodeVariableVisitor variableVisitor = new ExprNodeVariableVisitor(services.getVariableCompileTimeResolver());
        whenExpressionNode.accept(variableVisitor);
        this.variableNames = variableVisitor.getVariableNames();
        boolean containsBuiltinProperties = this.containsBuiltinProperties(whenExpressionNode);
        if (!containsBuiltinProperties && assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (!containsBuiltinProperties && this.andWhenTerminatedExpressionNodeEval != null) {
            containsBuiltinProperties = this.containsBuiltinProperties(andWhenTerminatedExpr);
        }
        if (!containsBuiltinProperties && afterTerminateAssignments != null) {
            for (OnTriggerSetAssignment assignment : afterTerminateAssignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        this.isUsingBuiltinProperties = containsBuiltinProperties;
        this.variableReadWritePackage = assignments != null && !assignments.isEmpty() ? new VariableReadWritePackageForge(assignments, statementRawInfo.getStatementName(), services) : null;
        this.variableReadWritePackageAfterTerminated = afterTerminateAssignments != null ? new VariableReadWritePackageForge(afterTerminateAssignments, statementRawInfo.getStatementName(), services) : null;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Schedule callback id not provided");
        }
        CodegenMethod method = parent.makeChild(OutputConditionFactory.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(OutputConditionExpressionFactory.class, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getResultSetProcessorHelperFactory", new CodegenExpression[0]).add("makeOutputConditionExpression", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setWhenExpressionNodeEval", ExprNodeUtilityCodegen.codegenEvaluator(this.whenExpressionNodeEval.getForge(), method, this.getClass(), classScope)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setAndWhenTerminatedExpressionNodeEval", this.andWhenTerminatedExpressionNodeEval == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.andWhenTerminatedExpressionNodeEval.getForge(), method, this.getClass(), classScope)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setUsingBuiltinProperties", CodegenExpressionBuilder.constant(this.isUsingBuiltinProperties)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setVariableReadWritePackage", this.variableReadWritePackage == null ? CodegenExpressionBuilder.constantNull() : this.variableReadWritePackage.make(method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setVariableReadWritePackageAfterTerminated", this.variableReadWritePackageAfterTerminated == null ? CodegenExpressionBuilder.constantNull() : this.variableReadWritePackageAfterTerminated.make(method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setVariables", this.variableNames == null ? CodegenExpressionBuilder.constantNull() : VariableDeployTimeResolver.makeResolveVariables(this.variableNames.values(), symbols.getAddInitSvc(method))).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("addReadyCallback", CodegenExpressionBuilder.ref("factory"))).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public void collectSchedules(List<ScheduleHandleCallbackProvider> scheduleHandleCallbackProviders) {
        scheduleHandleCallbackProviders.add(this);
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

