/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitLimitType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitRateType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionCountForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionCrontabForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionFactoryForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionNullFactoryForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionTermFactoryForge;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionTimeForge;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputConditionFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(OutputConditionFactoryFactory.class);

    public static OutputConditionFactoryForge createCondition(OutputLimitSpec outputLimitSpec, boolean isGrouped, boolean isWithHavingClause, boolean isStartConditionOnCreation, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        if (outputLimitSpec == null) {
            return OutputConditionNullFactoryForge.INSTANCE;
        }
        VariableMetaData variableMetaData = null;
        if (outputLimitSpec.getVariableName() != null) {
            variableMetaData = services.getVariableCompileTimeResolver().resolve(outputLimitSpec.getVariableName());
            if (variableMetaData == null) {
                throw new ExprValidationException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
            }
            String message = VariableUtil.checkVariableContextName(statementRawInfo.getContextName(), variableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST && isGrouped) {
            return OutputConditionNullFactoryForge.INSTANCE;
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionCrontabForge(outputLimitSpec.getCrontabAtSchedule(), isStartConditionOnCreation, statementRawInfo, services);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionExpressionForge(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), outputLimitSpec.getAndAfterTerminateExpr(), outputLimitSpec.getAndAfterTerminateThenExpressions(), isStartConditionOnCreation, statementRawInfo, services);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (variableMetaData != null && !JavaClassHelper.isNumericNonFP(variableMetaData.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionCountForge(rate, variableMetaData);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TERM) {
            if (outputLimitSpec.getAndAfterTerminateExpr() == null && (outputLimitSpec.getAndAfterTerminateThenExpressions() == null || outputLimitSpec.getAndAfterTerminateThenExpressions().isEmpty())) {
                return new OutputConditionTermFactoryForge();
            }
            return new OutputConditionExpressionForge(new ExprConstantNodeImpl(false), Collections.emptyList(), outputLimitSpec.getAndAfterTerminateExpr(), outputLimitSpec.getAndAfterTerminateThenExpressions(), isStartConditionOnCreation, statementRawInfo, services);
        }
        if (log.isDebugEnabled()) {
            log.debug(".createCondition creating OutputConditionTime with interval length " + outputLimitSpec.getRate());
        }
        if (variableMetaData != null && !JavaClassHelper.isNumeric(variableMetaData.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionTimeForge(outputLimitSpec.getTimePeriodExpr(), isStartConditionOnCreation);
    }
}

