/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCrontabState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.schedule.ScheduleComputeHelper;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCrontab
implements OutputConditionPolled {
    private final AgentInstanceContext agentInstanceContext;
    private final OutputConditionPolledCrontabState state;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCrontab.class);

    public OutputConditionPolledCrontab(AgentInstanceContext agentInstanceContext, OutputConditionPolledCrontabState state) {
        this.agentInstanceContext = agentInstanceContext;
        this.state = state;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        boolean output = false;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        ClasspathImportServiceRuntime classpathImportService = this.agentInstanceContext.getClasspathImportServiceRuntime();
        if (this.state.getCurrentReferencePoint() == null) {
            this.state.setCurrentReferencePoint(currentTime);
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus()));
            output = true;
        }
        if (this.state.getNextScheduledTime() <= currentTime) {
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus()));
            output = true;
        }
        return output;
    }
}

