/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCrontab;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCrontabState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.schedule.ScheduleParameterException;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import com.espertech.esper.common.internal.schedule.ScheduleSpecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCrontabFactory
implements OutputConditionPolledFactory {
    private final ExprEvaluator[] expressions;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCrontabFactory.class);

    public OutputConditionPolledCrontabFactory(ExprEvaluator[] expressions) {
        this.expressions = expressions;
    }

    @Override
    public OutputConditionPolled makeNew(AgentInstanceContext agentInstanceContext) {
        ScheduleSpec scheduleSpec;
        try {
            Object[] scheduleSpecParameterList = OutputConditionPolledCrontabFactory.evaluate(this.expressions, agentInstanceContext);
            scheduleSpec = ScheduleSpecUtil.computeValues(scheduleSpecParameterList);
        }
        catch (ScheduleParameterException e) {
            throw new IllegalArgumentException("Invalid schedule specification : " + e.getMessage(), e);
        }
        OutputConditionPolledCrontabState state = new OutputConditionPolledCrontabState(scheduleSpec, null, 0L);
        return new OutputConditionPolledCrontab(agentInstanceContext, state);
    }

    @Override
    public OutputConditionPolled makeFromState(AgentInstanceContext agentInstanceContext, OutputConditionPolledState state) {
        return new OutputConditionPolledCrontab(agentInstanceContext, (OutputConditionPolledCrontabState)state);
    }

    private static Object[] evaluate(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error(message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }
}

