/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionTypeUtil;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpression;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpressionState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.epl.variable.core.VariableReadWritePackage;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactoryDisallow;

public class OutputConditionPolledExpressionFactory
implements OutputConditionPolledFactory {
    private ExprEvaluator whenExpression;
    private VariableReadWritePackage variableReadWritePackage;
    private boolean isUsingBuiltinProperties;
    private EventType builtinPropertiesEventType;

    public void setWhenExpression(ExprEvaluator whenExpression) {
        this.whenExpression = whenExpression;
    }

    public void setVariableReadWritePackage(VariableReadWritePackage variableReadWritePackage) {
        this.variableReadWritePackage = variableReadWritePackage;
    }

    public void setUsingBuiltinProperties(boolean usingBuiltinProperties) {
        this.isUsingBuiltinProperties = usingBuiltinProperties;
    }

    @Override
    public OutputConditionPolled makeFromState(AgentInstanceContext agentInstanceContext, OutputConditionPolledState state) {
        ObjectArrayEventBean builtinProperties = null;
        if (this.isUsingBuiltinProperties) {
            this.initType(agentInstanceContext);
            builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), this.builtinPropertiesEventType);
        }
        OutputConditionPolledExpressionState expressionState = (OutputConditionPolledExpressionState)state;
        return new OutputConditionPolledExpression(this, expressionState, agentInstanceContext, builtinProperties);
    }

    @Override
    public OutputConditionPolled makeNew(AgentInstanceContext agentInstanceContext) {
        ObjectArrayEventBean builtinProperties = null;
        Long lastOutputTimestamp = null;
        if (this.isUsingBuiltinProperties) {
            this.initType(agentInstanceContext);
            builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), this.builtinPropertiesEventType);
            lastOutputTimestamp = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
        OutputConditionPolledExpressionState state = new OutputConditionPolledExpressionState(0, 0, 0, 0, lastOutputTimestamp);
        return new OutputConditionPolledExpression(this, state, agentInstanceContext, builtinProperties);
    }

    public ExprEvaluator getWhenExpression() {
        return this.whenExpression;
    }

    public VariableReadWritePackage getVariableReadWritePackage() {
        return this.variableReadWritePackage;
    }

    private void initType(AgentInstanceContext agentInstanceContext) {
        if (this.builtinPropertiesEventType == null) {
            this.builtinPropertiesEventType = OutputConditionExpressionTypeUtil.getBuiltInEventType(agentInstanceContext.getModuleName(), new BeanEventTypeFactoryDisallow(agentInstanceContext.getEventBeanTypedEventFactory()));
        }
    }
}

