/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.metrics.audit.AuditPath;
import com.espertech.esper.common.internal.statement.dispatch.UpdateDispatchView;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessViewDirectDistinctOrAfter
extends OutputProcessViewBaseWAfter {
    private static final Logger log = LoggerFactory.getLogger(OutputProcessViewDirectDistinctOrAfter.class);
    private final OutputProcessViewDirectDistinctOrAfterFactory parent;

    public OutputProcessViewDirectDistinctOrAfter(AgentInstanceContext agentInstanceContext, ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewDirectDistinctOrAfterFactory parent) {
        super(agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!super.checkAfterCondition(newOldEvents, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
            }
            return;
        }
        boolean forceOutput = false;
        if (newData == null && oldData == null && (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null)) {
            forceOutput = true;
        }
        if (this.child != null) {
            this.postProcess(forceOutput, newOldEvents, this.child);
        }
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        if (!this.checkAfterCondition(newOldEvents, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
            }
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (this.child != null) {
            this.postProcess(false, newOldEvents, this.child);
        }
    }

    protected void postProcess(boolean force, UniformPair<EventBean[]> newOldEvents, UpdateDispatchView childView) {
        OutputStrategyUtil.output(force, newOldEvents, childView);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct(), this.parent.getDistinctKeyGetter());
    }

    @Override
    public void terminated() {
    }
}

