/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootState;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternMatchCallback;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalRootStateNode
extends EvalStateNode
implements Evaluator,
EvalRootState {
    protected final EvalRootNode rootNode;
    protected EvalNode rootSingleChildNode;
    protected EvalStateNode topStateNode;
    private PatternMatchCallback callback;
    private static final Logger log = LoggerFactory.getLogger(EvalRootStateNode.class);

    public EvalRootStateNode(EvalRootNode rootNode, EvalNode rootSingleChildNode) {
        super(null);
        this.rootNode = rootNode;
        this.rootSingleChildNode = rootSingleChildNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.rootSingleChildNode;
    }

    @Override
    public final void setCallback(PatternMatchCallback callback) {
        this.callback = callback;
    }

    @Override
    public void quit() {
        this.rootNode.agentInstanceContext.getInstrumentationProvider().qPatternRootQuit();
        if (this.topStateNode != null) {
            this.topStateNode.quit();
        }
        this.topStateNode = null;
        this.rootNode.agentInstanceContext.getInstrumentationProvider().aPatternRootQuit();
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.rootNode.agentInstanceContext.getInstrumentationProvider().qPatternRootStart(beginState);
        this.topStateNode = this.rootSingleChildNode.newState(this);
        this.topStateNode.start(beginState);
        this.rootNode.agentInstanceContext.getInstrumentationProvider().aPatternRootStart();
    }

    @Override
    public final void stop() {
        this.quit();
    }

    @Override
    public void startRecoverable(boolean startRecoverable, MatchedEventMap beginState) {
        this.start(beginState);
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.rootNode.getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternRootEvaluateTrue(matchEvent);
        if (isQuitted) {
            this.topStateNode = null;
        }
        this.callback.matchFound(matchEvent.getMatchingEventsAsMap(), optionalTriggeringEvent);
        agentInstanceContext.getInstrumentationProvider().aPatternRootEvaluateTrue(isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.rootNode.getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternRootEvalFalse();
        if (this.topStateNode != null) {
            this.topStateNode.quit();
            this.topStateNode = null;
        }
        agentInstanceContext.getInstrumentationProvider().aPatternRootEvalFalse();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitRoot(this);
        if (this.topStateNode != null) {
            this.topStateNode.accept(visitor);
        }
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalRootStateNode topStateNode=" + this.topStateNode;
    }

    public EvalStateNode getTopStateNode() {
        return this.topStateNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (this.topStateNode != null) {
            this.topStateNode.removeMatch(matchEvent);
        }
    }
}

