/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.event.map.MapEventBean;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MatchedEventConvertorForge {
    private final LinkedHashMap<String, Pair<EventType, String>> filterTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final LinkedHashSet<String> allTags;
    private final Set<Integer> streamsUsedCanNull;
    private final boolean baseStreamIndexOne;

    public MatchedEventConvertorForge(LinkedHashMap<String, Pair<EventType, String>> filterTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTags, Set<Integer> streamsUsedCanNull, boolean baseStreamIndexOne) {
        this.filterTypes = filterTypes == null ? new LinkedHashMap() : new LinkedHashMap<String, Pair<EventType, String>>(filterTypes);
        this.arrayEventTypes = arrayEventTypes == null ? new LinkedHashMap() : new LinkedHashMap<String, Pair<EventType, String>>(arrayEventTypes);
        this.allTags = allTags == null ? new LinkedHashSet() : allTags;
        this.streamsUsedCanNull = streamsUsedCanNull;
        this.baseStreamIndexOne = baseStreamIndexOne;
    }

    public CodegenMethod make(CodegenMethodScope parent, CodegenClassScope classScope) {
        int indexStream;
        int indexTag;
        int size = this.filterTypes.size() + this.arrayEventTypes.size();
        CodegenMethod method = parent.makeChild(EventBean[].class, this.getClass(), (CodegenScope)classScope).addParam(MatchedEventMap.class, "mem");
        if (size == 0 || this.streamsUsedCanNull != null && this.streamsUsedCanNull.isEmpty()) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.publicConstValue(CollectionUtil.class, "EVENTBEANARRAY_EMPTY"));
            return method;
        }
        int sizeArray = this.baseStreamIndexOne ? size + 1 : size;
        method.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.newArrayByLength(EventBean.class, CodegenExpressionBuilder.constant(sizeArray))).declareVar(Object[].class, "buf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("mem"), "getMatchingEvents", new CodegenExpression[0]));
        int count = 0;
        for (Map.Entry<String, Pair<EventType, String>> entry : this.filterTypes.entrySet()) {
            indexTag = this.findTag(this.allTags, entry.getKey());
            int n = indexStream = this.baseStreamIndexOne ? count + 1 : count;
            if (this.streamsUsedCanNull == null || this.streamsUsedCanNull.contains(indexStream)) {
                method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constant(indexStream), CodegenExpressionBuilder.cast(EventBean.class, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("buf"), CodegenExpressionBuilder.constant(indexTag))));
            }
            ++count;
        }
        for (Map.Entry<String, Pair<EventType, String>> entry : this.arrayEventTypes.entrySet()) {
            indexTag = this.findTag(this.allTags, entry.getKey());
            int n = indexStream = this.baseStreamIndexOne ? count + 1 : count;
            if (this.streamsUsedCanNull == null || this.streamsUsedCanNull.contains(indexStream)) {
                method.getBlock().declareVar(EventBean[].class, "arr" + count, CodegenExpressionBuilder.cast(EventBean[].class, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("buf"), CodegenExpressionBuilder.constant(indexTag)))).declareVar(Map.class, "map" + count, CodegenExpressionBuilder.staticMethod(Collections.class, "singletonMap", CodegenExpressionBuilder.constant(entry.getKey()), CodegenExpressionBuilder.ref("arr" + count))).assignArrayElement(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constant(indexStream), CodegenExpressionBuilder.newInstance(MapEventBean.class, CodegenExpressionBuilder.ref("map" + count), CodegenExpressionBuilder.constantNull()));
            }
            ++count;
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("events"));
        return method;
    }

    private int findTag(LinkedHashSet<String> allTags, String tag) {
        int index = 0;
        for (String oneTag : allTags) {
            if (tag.equals(oneTag)) {
                return index;
            }
            ++index;
        }
        throw new IllegalStateException("Unexpected tag '" + tag + "'");
    }

    public CodegenExpression makeAnonymous(CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass clazz = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), MatchedEventConvertor.class);
        CodegenMethod convert = CodegenMethod.makeParentNode(EventBean[].class, this.getClass(), classScope).addParam(MatchedEventMap.class, "events");
        clazz.addMethod("convert", convert);
        convert.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(this.make(convert, classScope), CodegenExpressionBuilder.ref("events")));
        return clazz;
    }
}

