/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.every;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryNode;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryNode evalEveryNode;
    protected final List<EvalStateNode> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryStateNode(Evaluator parentNode, EvalEveryNode evalEveryNode) {
        super(parentNode);
        this.evalEveryNode = evalEveryNode;
        this.spawnedNodes = new ArrayList<EvalStateNode>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalEveryNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalEveryNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalEveryNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalEveryNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryStart(this.evalEveryNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalEveryNode.factoryNode, agentInstanceContext);
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.evalEveryNode.getChildNode().newState(this);
        this.spawnedNodes.add(childState);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryStart();
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalEveryNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryEvalFalse(this.evalEveryNode.factoryNode);
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        if (!restartable) {
            agentInstanceContext.getAuditProvider().patternFalse(this.evalEveryNode.getFactoryNode(), this, agentInstanceContext);
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalEveryNode.factoryNode, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, false);
            return;
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getStatementName());
        EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.add(spawned);
            spawned.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryEvalFalse();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalEveryNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryEvaluateTrue(this.evalEveryNode.factoryNode, matchEvent);
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode() && !fromNode.isObserverStateNodeNonRestarting()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getStatementName());
            EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                this.spawnedNodes.add(spawned);
                spawned.setParentEvaluator(this);
            }
        }
        agentInstanceContext.getAuditProvider().patternTrue(this.evalEveryNode.getFactoryNode(), this, matchEvent, false, agentInstanceContext);
        this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
        agentInstanceContext.getInstrumentationProvider().aPatternEveryEvaluateTrue();
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalEveryNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryQuit(this.evalEveryNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalEveryNode.factoryNode, agentInstanceContext);
        for (EvalStateNode child : this.spawnedNodes) {
            child.quit();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEvery(this.evalEveryNode.getFactoryNode(), this, this.beginState, new Object[0]);
        for (EvalStateNode spawnedNode : this.spawnedNodes) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

