/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.everydistinct;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.everydistinct.EvalEveryDistinctFactoryNode;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import java.io.StringWriter;
import java.util.List;

public class EvalEveryDistinctForgeNode
extends EvalForgeNodeBase {
    private List<ExprNode> expressions;
    private transient MatchedEventConvertorForge convertor;
    private TimePeriodComputeForge timePeriodComputeForge;
    private ExprNode expiryTimeExp;
    private List<ExprNode> distinctExpressions;
    private MultiKeyClassRef distinctMultiKey;

    public EvalEveryDistinctForgeNode(boolean attachPatternText, List<ExprNode> expressions) {
        super(attachPatternText);
        this.expressions = expressions;
    }

    @Override
    protected Class typeOfFactory() {
        return EvalEveryDistinctFactoryNode.class;
    }

    @Override
    protected String nameOfFactory() {
        return "everyDistinct";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression distinctEval = MultiKeyCodegen.codegenExprEvaluatorMayMultikey(this.distinctExpressions.toArray(new ExprNode[0]), null, this.distinctMultiKey, method, classScope);
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setChildNode", CodegenExpressionBuilder.localMethod(this.getChildNodes().get(0).makeCodegen(method, symbols, classScope), new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setDistinctExpression", distinctEval).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setDistinctTypes", CodegenExpressionBuilder.constant(ExprNodeUtilityQuery.getExprResultTypes(this.distinctExpressions))).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setDistinctSerde", this.distinctMultiKey.getExprMKSerde(method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setConvertor", this.convertor.makeAnonymous(method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setTimePeriodCompute", this.timePeriodComputeForge == null ? CodegenExpressionBuilder.constantNull() : this.timePeriodComputeForge.makeEvaluator(method, classScope));
    }

    @Override
    public void collectSelfFilterAndSchedule(List<FilterSpecCompiled> filters, List<ScheduleHandleCallbackProvider> schedules) {
    }

    public final String toString() {
        return "EvalEveryNode children=" + this.getChildNodes().size();
    }

    public List<ExprNode> getExpressions() {
        return this.expressions;
    }

    public List<ExprNode> getDistinctExpressions() {
        return this.distinctExpressions;
    }

    public void setConvertor(MatchedEventConvertorForge convertor) {
        this.convertor = convertor;
    }

    public void setDistinctExpressions(List<ExprNode> distinctExpressions, MultiKeyClassRef distincMultiKey, TimePeriodComputeForge timePeriodComputeForge, ExprNode expiryTimeExp) {
        this.distinctExpressions = distinctExpressions;
        this.distinctMultiKey = distincMultiKey;
        this.timePeriodComputeForge = timePeriodComputeForge;
        this.expiryTimeExp = expiryTimeExp;
    }

    public boolean isFilterChildNonQuitting() {
        return true;
    }

    public boolean isStateful() {
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("every-distinct(");
        ExprNodeUtilityPrint.toExpressionStringParameterList(this.distinctExpressions, writer);
        if (this.expiryTimeExp != null) {
            writer.append(",");
            writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.expiryTimeExp));
        }
        writer.append(") ");
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.UNARY;
    }
}

