/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.everydistinct;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionUtil;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryStateNode;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.common.internal.epl.pattern.everydistinct.EvalEveryDistinctNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryDistinctStateExpireKeyNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryDistinctNode everyNode;
    protected final Map<EvalStateNode, LinkedHashMap<Object, Long>> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryDistinctStateExpireKeyNode(Evaluator parentNode, EvalEveryDistinctNode everyNode) {
        super(parentNode);
        this.everyNode = everyNode;
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, LinkedHashMap<Object, Long>>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.everyNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.everyNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes.keySet());
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.everyNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.everyNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctStart(this.everyNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.everyNode.factoryNode, agentInstanceContext);
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.everyNode.getChildNode().newState(this);
        this.spawnedNodes.put(childState, new LinkedHashMap());
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctStart();
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.everyNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctEvalFalse(this.everyNode.factoryNode);
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getStatementName());
        EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new LinkedHashMap());
            spawned.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctEvalFalse();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.everyNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctEvaluateTrue(this.everyNode.factoryNode, matchEvent);
        Object matchEventKey = PatternExpressionUtil.getKeys(matchEvent, this.everyNode.getFactoryNode().getConvertor(), this.everyNode.getFactoryNode().getDistinctExpression(), this.everyNode.getContext().getAgentInstanceContext());
        boolean haveSeenThis = false;
        LinkedHashMap<Object, Long> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            Map.Entry<Object, Long> entry;
            Iterator<Map.Entry<Object, Long>> it = keysFromNode.entrySet().iterator();
            long currentTime = this.everyNode.getContext().getAgentInstanceContext().getTimeProvider().getTime();
            while (it.hasNext() && currentTime >= (entry = it.next()).getValue()) {
                it.remove();
            }
            if (keysFromNode.containsKey(matchEventKey)) {
                haveSeenThis = true;
            } else {
                long expiryTime = this.everyNode.getFactoryNode().absExpiry(this.everyNode.getContext());
                keysFromNode.put(matchEventKey, expiryTime);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getStatementName());
            EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                LinkedHashMap<Object, Long> keyset = new LinkedHashMap<Object, Long>();
                if (keysFromNode != null) {
                    keyset.putAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            agentInstanceContext.getAuditProvider().patternTrue(this.everyNode.getFactoryNode(), this, matchEvent, false, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctEvaluateTrue(null, keysFromNode, matchEventKey, haveSeenThis);
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.everyNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctQuit(this.everyNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.everyNode.factoryNode, agentInstanceContext);
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEveryDistinct(this.everyNode.getFactoryNode(), this, this.beginState, this.spawnedNodes.values());
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

