/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.everydistinct;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionUtil;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryStateNode;
import com.espertech.esper.common.internal.epl.pattern.every.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.common.internal.epl.pattern.everydistinct.EvalEveryDistinctNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryDistinctStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryDistinctNode everyDistinctNode;
    protected final Map<EvalStateNode, Set<Object>> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryDistinctStateNode(Evaluator parentNode, EvalEveryDistinctNode everyDistinctNode) {
        super(parentNode);
        this.everyDistinctNode = everyDistinctNode;
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, Set<Object>>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.everyDistinctNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.everyDistinctNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes.keySet());
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.everyDistinctNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.everyDistinctNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctStart(this.everyDistinctNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.everyDistinctNode.factoryNode, agentInstanceContext);
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.everyDistinctNode.getChildNode().newState(this);
        this.spawnedNodes.put(childState, new HashSet());
        if (this.spawnedNodes.size() != 1) {
            throw new IllegalStateException("EVERY state node is expected to have single child state node");
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctStart();
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.everyDistinctNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctEvalFalse(this.everyDistinctNode.factoryNode);
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getStatementName());
        EvalStateNode spawned = this.everyDistinctNode.getChildNode().newState(spawnEvaluator);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new HashSet());
            spawned.setParentEvaluator(this);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctEvalFalse();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.everyDistinctNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctEvaluateTrue(this.everyDistinctNode.factoryNode, matchEvent);
        Object matchEventKey = PatternExpressionUtil.getKeys(matchEvent, this.everyDistinctNode.getFactoryNode().getConvertor(), this.everyDistinctNode.getFactoryNode().getDistinctExpression(), this.everyDistinctNode.getContext().getAgentInstanceContext());
        boolean haveSeenThis = false;
        Set<Object> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            if (keysFromNode.contains(matchEventKey)) {
                haveSeenThis = true;
            } else {
                keysFromNode.add(matchEventKey);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyDistinctNode.getContext().getStatementName());
            EvalStateNode spawned = this.everyDistinctNode.getChildNode().newState(spawnEvaluator);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                HashSet<Object> keyset = new HashSet<Object>();
                if (keysFromNode != null) {
                    keyset.addAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            agentInstanceContext.getAuditProvider().patternTrue(this.everyDistinctNode.getFactoryNode(), this, matchEvent, false, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctEvaluateTrue(keysFromNode, null, matchEventKey, haveSeenThis);
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.everyDistinctNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternEveryDistinctQuit(this.everyDistinctNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.everyDistinctNode.factoryNode, agentInstanceContext);
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternEveryDistinctQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEveryDistinct(this.everyDistinctNode.getFactoryNode(), this, this.beginState, this.spawnedNodes.values());
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

