/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.followedby;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.followedby.EvalFollowedByNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.HashMap;
import java.util.Set;

public class EvalFollowedByStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalFollowedByNode evalFollowedByNode;
    protected final HashMap<EvalStateNode, Integer> nodes;

    public EvalFollowedByStateNode(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode) {
        super(parentNode);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.nodes.keySet());
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByStart(this.evalFollowedByNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalFollowedByNode.factoryNode, agentInstanceContext);
        EvalNode child = this.evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this);
        this.nodes.put(childState, 0);
        childState.start(beginState);
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByStart();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        Integer index = this.nodes.get(fromNode);
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByEvaluateTrue(this.evalFollowedByNode.factoryNode, matchEvent, index);
        if (isQuitted) {
            this.nodes.remove(fromNode);
        }
        if (index == null) {
            agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvaluateTrue(false);
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        boolean isFollowedByQuitted = false;
        if (index == numChildNodes - 1) {
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
                agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFollowedByNode.factoryNode, agentInstanceContext);
            }
            agentInstanceContext.getAuditProvider().patternTrue(this.evalFollowedByNode.getFactoryNode(), this, matchEvent, isFollowedByQuitted, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted, optionalTriggeringEvent);
        } else {
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this);
            this.nodes.put(childState, index + 1);
            childState.start(matchEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvaluateTrue(isFollowedByQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByEvalFalse(this.evalFollowedByNode.factoryNode);
        fromNode.quit();
        this.nodes.remove(fromNode);
        if (this.nodes.isEmpty()) {
            agentInstanceContext.getAuditProvider().patternFalse(this.evalFollowedByNode.getFactoryNode(), this, agentInstanceContext);
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFollowedByNode.factoryNode, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
            this.quitInternal();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvalFalse();
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByQuit(this.evalFollowedByNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFollowedByNode.factoryNode, agentInstanceContext);
        if (this.nodes.isEmpty()) {
            agentInstanceContext.getInstrumentationProvider().aPatternFollowedByQuit();
            return;
        }
        this.quitInternal();
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitFollowedBy(this.evalFollowedByNode.getFactoryNode(), this, this.nodes);
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }

    private final void quitInternal() {
        for (EvalStateNode child : this.nodes.keySet()) {
            child.quit();
        }
        this.nodes.clear();
    }
}

