/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.client.soda.GuardEnum;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternGuardSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.guard.EvalGuardFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalGuardForgeNode
extends EvalForgeNodeBase {
    private PatternGuardSpec patternGuardSpec;
    private GuardForge guardForge;
    private static final Logger log = LoggerFactory.getLogger(EvalGuardForgeNode.class);

    public EvalGuardForgeNode(boolean attachPatternText, PatternGuardSpec patternGuardSpec) {
        super(attachPatternText);
        this.patternGuardSpec = patternGuardSpec;
    }

    public PatternGuardSpec getPatternGuardSpec() {
        return this.patternGuardSpec;
    }

    public void setGuardForge(GuardForge guardForge) {
        this.guardForge = guardForge;
    }

    public GuardForge getGuardForge() {
        return this.guardForge;
    }

    public final String toString() {
        return "EvalGuardNode guardForge=" + this.guardForge + "  children=" + this.getChildNodes().size();
    }

    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    @Override
    protected Class typeOfFactory() {
        return EvalGuardFactoryNode.class;
    }

    @Override
    protected String nameOfFactory() {
        return "guard";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setChildNode", CodegenExpressionBuilder.localMethod(this.getChildNodes().get(0).makeCodegen(method, symbols, classScope), new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setGuardFactory", this.guardForge.makeCodegen(method, symbols, classScope));
    }

    @Override
    public void collectSelfFilterAndSchedule(List<FilterSpecCompiled> filters, List<ScheduleHandleCallbackProvider> schedules) {
        this.guardForge.collectSchedule(schedules);
    }

    public String toPrecedenceFreeEPL() {
        StringWriter writer = new StringWriter();
        this.toPrecedenceFreeEPL(writer);
        return writer.toString();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        if (this.patternGuardSpec.getObjectNamespace().equals(GuardEnum.WHILE_GUARD.getNamespace()) && this.patternGuardSpec.getObjectName().equals(GuardEnum.WHILE_GUARD.getName())) {
            writer.write(" while ");
        } else {
            writer.write(" where ");
            writer.write(this.patternGuardSpec.getObjectNamespace());
            writer.write(":");
            writer.write(this.patternGuardSpec.getObjectName());
        }
        writer.write("(");
        ExprNodeUtilityPrint.toExpressionStringParameterList(this.patternGuardSpec.getObjectParameters(), writer);
        writer.write(")");
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.GUARD_POSTFIX;
    }
}

