/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.epl.pattern.guard.EventGuardVisitor;
import com.espertech.esper.common.internal.epl.pattern.guard.Guard;
import com.espertech.esper.common.internal.epl.pattern.guard.Quitable;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionGuard
implements Guard {
    private static final Logger log = LoggerFactory.getLogger(ExpressionGuard.class);
    private final Quitable quitable;
    private final MatchedEventConvertor convertor;
    private final ExprEvaluator expression;

    public ExpressionGuard(MatchedEventConvertor convertor, ExprEvaluator expression, Quitable quitable) {
        this.quitable = quitable;
        this.convertor = convertor;
        this.expression = expression;
    }

    @Override
    public void startGuard() {
    }

    @Override
    public boolean inspect(MatchedEventMap matchEvent) {
        EventBean[] eventsPerStream = this.convertor.convert(matchEvent);
        try {
            Object result = this.expression.evaluate(eventsPerStream, true, this.quitable.getContext().getAgentInstanceContext());
            if (result == null) {
                return false;
            }
            if (result.equals(Boolean.TRUE)) {
                return true;
            }
            this.quitable.guardQuit();
            return false;
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate expression for pattern-guard for statement '" + this.quitable.getContext().getAgentInstanceContext().getStatementName() + "'";
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error(message, (Throwable)ex);
            throw new EPException(message);
        }
    }

    @Override
    public void stopGuard() {
    }

    @Override
    public void accept(EventGuardVisitor visitor) {
        visitor.visitGuard(0, new Object[0]);
    }
}

