/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.PatternDeltaCompute;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionUtil;
import com.espertech.esper.common.internal.epl.pattern.guard.Guard;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardFactory;
import com.espertech.esper.common.internal.epl.pattern.guard.Quitable;
import com.espertech.esper.common.internal.epl.pattern.guard.TimerWithinOrMaxCountGuard;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;

public class TimerWithinOrMaxCountGuardFactory
implements GuardFactory {
    private PatternDeltaCompute deltaCompute;
    private ExprEvaluator countEval;
    private MatchedEventConvertor optionalConvertor;
    private int scheduleCallbackId = -1;

    public void setDeltaCompute(PatternDeltaCompute deltaCompute) {
        this.deltaCompute = deltaCompute;
    }

    public void setOptionalConvertor(MatchedEventConvertor optionalConvertor) {
        this.optionalConvertor = optionalConvertor;
    }

    public void setCountEval(ExprEvaluator countEval) {
        this.countEval = countEval;
    }

    public void setScheduleCallbackId(int scheduleCallbackId) {
        this.scheduleCallbackId = scheduleCallbackId;
    }

    public int getScheduleCallbackId() {
        return this.scheduleCallbackId;
    }

    public long computeTime(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        return this.deltaCompute.computeDelta(beginState, context);
    }

    public int computeNumCountTo(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        EventBean[] events = this.optionalConvertor == null ? null : this.optionalConvertor.convert(beginState);
        Object numCountToVal = PatternExpressionUtil.evaluateChecked("Timer-Within-Or-Max-Count guard", this.countEval, events, context.getAgentInstanceContext());
        if (null == numCountToVal) {
            throw new EPException("Timer-within-or-max second parameter evaluated to a null-value");
        }
        return (Integer)numCountToVal;
    }

    @Override
    public Guard makeGuard(PatternAgentInstanceContext context, MatchedEventMap beginState, Quitable quitable, Object guardState) {
        return new TimerWithinOrMaxCountGuard(this.computeTime(beginState, context), this.computeNumCountTo(beginState, context), quitable);
    }
}

