/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.core.PatternDeltaComputeUtil;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardForge;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardParameterException;
import com.espertech.esper.common.internal.epl.pattern.guard.TimerWithinOrMaxCountGuardFactory;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;

public class TimerWithinOrMaxCountGuardForge
implements GuardForge,
ScheduleHandleCallbackProvider {
    private ExprNode timeExpr;
    private ExprNode numCountToExpr;
    private int scheduleCallbackId = -1;
    private TimeAbacus timeAbacus;
    protected transient MatchedEventConvertorForge convertor;

    @Override
    public void setGuardParameters(List<ExprNode> parameters, MatchedEventConvertorForge convertor, StatementCompileTimeServices services) throws GuardParameterException {
        String message = "Timer-within-or-max-count guard requires two parameters: numeric or time period parameter and an integer-value expression parameter";
        if (parameters.size() != 2) {
            throw new GuardParameterException(message);
        }
        if (!JavaClassHelper.isNumeric(parameters.get(0).getForge().getEvaluationType())) {
            throw new GuardParameterException(message);
        }
        Class paramOneType = parameters.get(1).getForge().getEvaluationType();
        if (paramOneType != Integer.class && paramOneType != Integer.TYPE) {
            throw new GuardParameterException(message);
        }
        this.timeExpr = parameters.get(0);
        this.numCountToExpr = parameters.get(1);
        this.convertor = convertor;
        this.timeAbacus = services.getClasspathImportServiceCompileTime().getTimeAbacus();
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public void collectSchedule(List<ScheduleHandleCallbackProvider> schedules) {
        schedules.add(this);
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Unassigned schedule callback id");
        }
        CodegenMethod method = parent.makeChild(TimerWithinOrMaxCountGuardFactory.class, this.getClass(), (CodegenScope)classScope);
        CodegenExpression patternDelta = PatternDeltaComputeUtil.makePatternDeltaAnonymous(this.timeExpr, this.convertor, this.timeAbacus, method, classScope);
        CodegenExpression convertorExpr = this.numCountToExpr.getForge().getForgeConstantType().isCompileTimeConstant() ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.numCountToExpr.getForge(), method, this.getClass(), classScope);
        method.getBlock().declareVar(TimerWithinOrMaxCountGuardFactory.class, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getPatternFactoryService", new CodegenExpression[0]).add("guardTimerWithinOrMax", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setDeltaCompute", patternDelta).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setOptionalConvertor", convertorExpr).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setCountEval", ExprNodeUtilityCodegen.codegenEvaluator(this.numCountToExpr.getForge(), method, this.getClass(), classScope)).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

