/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.not;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.not.EvalNotFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.not.EvalNotNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalNotStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalNotNode evalNotNode;
    protected EvalStateNode childNode;
    private static final Logger log = LoggerFactory.getLogger(EvalNotStateNode.class);

    public EvalNotStateNode(Evaluator parentNode, EvalNotNode evalNotNode) {
        super(parentNode);
        this.evalNotNode = evalNotNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalNotNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        EvalNotFactoryNode factoryNode = this.evalNotNode.getFactoryNode();
        AgentInstanceContext agentInstanceContext = this.evalNotNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternNotStart(this.evalNotNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, factoryNode, agentInstanceContext);
        this.childNode = this.evalNotNode.getChildNode().newState(this);
        this.childNode.start(beginState);
        agentInstanceContext.getAuditProvider().patternTrue(factoryNode, this, beginState, false, agentInstanceContext);
        this.getParentEvaluator().evaluateTrue(beginState, this, false, null);
        agentInstanceContext.getInstrumentationProvider().aPatternNotStart();
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalNotNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternNotEvalFalse(this.evalNotNode.factoryNode);
        agentInstanceContext.getInstrumentationProvider().aPatternNotEvalFalse();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalNotNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternNotEvaluateTrue(this.evalNotNode.factoryNode, matchEvent);
        if (isQuitted) {
            this.childNode = null;
            agentInstanceContext.getAuditProvider().patternFalse(this.evalNotNode.getFactoryNode(), this, agentInstanceContext);
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalNotNode.factoryNode, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternNotEvaluateTrue(isQuitted);
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalNotNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternNotQuit(this.evalNotNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalNotNode.factoryNode, agentInstanceContext);
        if (this.childNode != null) {
            this.childNode.quit();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternNotQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitNot(this.evalNotNode.getFactoryNode(), this);
        if (this.childNode != null) {
            this.childNode.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return true;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalNotStateNode child=" + this.childNode;
    }
}

