/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.observer.EvalObserverNode;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserver;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalObserverStateNode
extends EvalStateNode
implements ObserverEventEvaluator {
    protected final EvalObserverNode evalObserverNode;
    protected EventObserver eventObserver;
    private static final Logger log = LoggerFactory.getLogger(EvalObserverStateNode.class);

    public EvalObserverStateNode(Evaluator parentNode, EvalObserverNode evalObserverNode) {
        super(parentNode);
        this.evalObserverNode = evalObserverNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.eventObserver.getBeginState())) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalObserverNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalObserverNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalObserverNode;
    }

    @Override
    public PatternAgentInstanceContext getContext() {
        return this.evalObserverNode.getContext();
    }

    @Override
    public void observerEvaluateTrue(MatchedEventMap matchEvent, boolean quitted) {
        AgentInstanceContext agentInstanceContext = this.evalObserverNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverEvaluateTrue(this.evalObserverNode.factoryNode, matchEvent);
        agentInstanceContext.getAuditProvider().patternTrue(this.evalObserverNode.getFactoryNode(), this, matchEvent, quitted, agentInstanceContext);
        if (quitted) {
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalObserverNode.factoryNode, agentInstanceContext);
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, quitted, null);
        agentInstanceContext.getInstrumentationProvider().aPatternObserverEvaluateTrue();
    }

    @Override
    public void observerEvaluateFalse(boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalObserverNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getAuditProvider().patternFalse(this.evalObserverNode.getFactoryNode(), this, agentInstanceContext);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalObserverNode.factoryNode, agentInstanceContext);
        this.getParentEvaluator().evaluateFalse(this, restartable);
    }

    @Override
    public void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalObserverNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverStart(this.evalObserverNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalObserverNode.factoryNode, agentInstanceContext);
        this.eventObserver = this.evalObserverNode.getFactoryNode().getObserverFactory().makeObserver(this.getContext(), beginState, this, null, this.getParentEvaluator().isFilterChildNonQuitting());
        this.eventObserver.startObserve();
        agentInstanceContext.getInstrumentationProvider().aPatternObserverStart();
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalObserverNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverQuit(this.evalObserverNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalObserverNode.factoryNode, agentInstanceContext);
        this.eventObserver.stopObserve();
        agentInstanceContext.getInstrumentationProvider().aPatternObserverQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitObserver(this.evalObserverNode.getFactoryNode(), this, this.eventObserver);
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return this.evalObserverNode.getFactoryNode().isObserverStateNodeNonRestarting();
    }

    public final String toString() {
        return "EvalObserverStateNode eventObserver=" + this.eventObserver;
    }
}

