/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverParameterException;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverParameterUtil;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerAtObserverFactory;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerIntervalObserverForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.schedule.ScheduleParameterException;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import com.espertech.esper.common.internal.schedule.ScheduleSpecUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerAtObserverForge
implements ObserverForge,
ScheduleHandleCallbackProvider {
    private static final Logger log = LoggerFactory.getLogger(TimerAtObserverForge.class);
    private List<ExprNode> parameters;
    private MatchedEventConvertorForge convertor;
    private ScheduleSpec spec = null;
    private int scheduleCallbackId = -1;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertorForge convertor, ExprValidationContext validationContext) throws ObserverParameterException {
        ObserverParameterUtil.validateNoNamedParameters("timer:at", parameters);
        if (log.isDebugEnabled()) {
            log.debug(".setObserverParameters " + parameters);
        }
        if (parameters.size() < 5 || parameters.size() > 9) {
            throw new ObserverParameterException("Invalid number of parameters for timer:at");
        }
        this.parameters = parameters;
        this.convertor = convertor;
        boolean allConstantResult = true;
        for (ExprNode param : parameters) {
            if (param instanceof ExprWildcard || param.getForge().getForgeConstantType().isCompileTimeConstant()) continue;
            allConstantResult = false;
        }
        if (allConstantResult) {
            try {
                List<Object> observerParameters = TimerAtObserverForge.evaluateCompileTime(parameters);
                this.spec = ScheduleSpecUtil.computeValues(observerParameters.toArray());
            }
            catch (ScheduleParameterException e) {
                throw new ObserverParameterException("Error computing crontab schedule specification: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression specExpr;
        CodegenExpression optionalConvertorExpr;
        CodegenExpression parametersExpr;
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Unassigned schedule callback id");
        }
        CodegenMethod method = parent.makeChild(TimerAtObserverFactory.class, TimerIntervalObserverForge.class, (CodegenScope)classScope);
        if (this.spec != null) {
            parametersExpr = CodegenExpressionBuilder.constantNull();
            optionalConvertorExpr = CodegenExpressionBuilder.constantNull();
            specExpr = this.spec.make(method, classScope);
        } else {
            specExpr = CodegenExpressionBuilder.constantNull();
            optionalConvertorExpr = this.convertor.makeAnonymous(method, classScope);
            parametersExpr = ExprNodeUtilityCodegen.codegenEvaluators(ExprNodeUtilityQuery.toArray(this.parameters), (CodegenMethodScope)method, this.getClass(), classScope);
        }
        method.getBlock().declareVar(TimerAtObserverFactory.class, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getPatternFactoryService", new CodegenExpression[0]).add("observerTimerAt", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setParameters", parametersExpr).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setOptionalConvertor", optionalConvertorExpr).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setSpec", specExpr).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public void collectSchedule(List<ScheduleHandleCallbackProvider> schedules) {
        schedules.add(this);
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    private static List<Object> evaluateCompileTime(List<ExprNode> parameters) throws EPException {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        for (ExprNode expr : parameters) {
            try {
                Object result = expr.getForge().getExprEvaluator().evaluate(null, true, null);
                results.add(result);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Tmer-at observer invalid parameter in expression " + count;
                if (ex.getMessage() != null) {
                    message = message + ": " + ex.getMessage();
                }
                log.error(message, (Throwable)ex);
                throw new EPException(message);
            }
        }
        return results;
    }
}

