/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOpPlusFastAddHelper;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOpPlusFastAddResult;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarPlusMinusForgeOp;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserver;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserverVisitor;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpec;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.schedule.SchedulingService;
import java.util.Calendar;

public class TimerScheduleObserver
implements EventObserver,
ScheduleHandleCallback {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "timer-at";
    protected final long scheduleSlot;
    protected MatchedEventMap beginState;
    protected final ObserverEventEvaluator observerEventEvaluator;
    private final TimerScheduleSpec spec;
    private final boolean isFilterChildNonQuitting;
    protected Calendar anchorTime;
    protected long anchorRemainder;
    protected boolean isTimerActive = false;
    private Calendar cachedLastScheduled;
    private long cachedCountRepeated = 0L;
    protected EPStatementHandleCallbackSchedule scheduleHandle;

    public TimerScheduleObserver(TimerScheduleSpec spec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, boolean isFilterChildNonQuitting) {
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getAgentInstanceContext().getScheduleBucket().allocateSlot();
        this.spec = spec;
        this.isFilterChildNonQuitting = isFilterChildNonQuitting;
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public final void scheduledTrigger() {
        AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverScheduledEval();
        agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        this.isTimerActive = false;
        SchedulingService schedulingService = agentInstanceContext.getSchedulingService();
        long nextScheduledTime = this.computeNextSetLastScheduled(schedulingService.getTime(), agentInstanceContext.getClasspathImportServiceRuntime().getTimeAbacus());
        boolean quit = !this.isFilterChildNonQuitting || nextScheduledTime == -1L;
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, quit);
        if (nextScheduledTime == -1L) {
            this.stopObserve();
            this.observerEventEvaluator.observerEvaluateFalse(false);
            agentInstanceContext.getInstrumentationProvider().aPatternObserverScheduledEval();
            return;
        }
        agentInstanceContext.getAuditProvider().scheduleAdd(nextScheduledTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
        agentInstanceContext.getInstrumentationProvider().aPatternObserverScheduledEval();
    }

    @Override
    public void startObserve() {
        long nextScheduledTime;
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
        SchedulingService schedulingService = agentInstanceContext.getSchedulingService();
        TimeAbacus timeAbacus = agentInstanceContext.getClasspathImportServiceRuntime().getTimeAbacus();
        if (this.anchorTime == null) {
            if (this.spec.getOptionalDate() == null) {
                this.anchorTime = Calendar.getInstance(this.observerEventEvaluator.getContext().getStatementContext().getClasspathImportServiceRuntime().getTimeZone());
                this.anchorRemainder = timeAbacus.calendarSet(schedulingService.getTime(), this.anchorTime);
            } else {
                this.anchorTime = this.spec.getOptionalDate();
                long l = this.anchorRemainder = this.spec.getOptionalRemainder() == null ? 0L : this.spec.getOptionalRemainder();
            }
        }
        if ((nextScheduledTime = this.computeNextSetLastScheduled(schedulingService.getTime(), timeAbacus)) == -1L) {
            this.stopObserve();
            this.observerEventEvaluator.observerEvaluateFalse(false);
            return;
        }
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        agentInstanceContext.getAuditProvider().scheduleAdd(nextScheduledTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.context, NAME_AUDITPROVIDER_SCHEDULE);
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.isTimerActive = false;
        this.scheduleHandle = null;
        this.cachedCountRepeated = Long.MAX_VALUE;
        this.cachedLastScheduled = null;
        this.anchorTime = null;
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 2, this.scheduleSlot, this.spec, this.anchorTime, this.cachedCountRepeated, this.cachedLastScheduled, this.isTimerActive);
    }

    private long computeNextSetLastScheduled(long currentTime, TimeAbacus timeAbacus) {
        if (this.cachedCountRepeated == Long.MAX_VALUE) {
            return -1L;
        }
        if (this.spec.getOptionalRepeatCount() == null && this.spec.getOptionalDate() != null && this.spec.getOptionalTimePeriod() == null) {
            this.cachedCountRepeated = Long.MAX_VALUE;
            long computed = timeAbacus.calendarGet(this.anchorTime, this.anchorRemainder);
            if (computed > currentTime) {
                return computed - currentTime;
            }
            return -1L;
        }
        if (this.spec.getOptionalRepeatCount() == null && this.spec.getOptionalTimePeriod() != null) {
            this.cachedCountRepeated = Long.MAX_VALUE;
            this.cachedLastScheduled = (Calendar)this.anchorTime.clone();
            CalendarPlusMinusForgeOp.actionCalendarPlusMinusTimePeriod(this.cachedLastScheduled, 1, this.spec.getOptionalTimePeriod());
            long computed = timeAbacus.calendarGet(this.cachedLastScheduled, this.anchorRemainder);
            if (computed > currentTime) {
                return computed - currentTime;
            }
            return -1L;
        }
        if (this.cachedLastScheduled == null) {
            this.cachedLastScheduled = (Calendar)this.anchorTime.clone();
            if (this.spec.getOptionalDate() != null) {
                this.cachedCountRepeated = 1L;
            }
        }
        CalendarOpPlusFastAddResult nextDue = CalendarOpPlusFastAddHelper.computeNextDue(currentTime, this.spec.getOptionalTimePeriod(), this.cachedLastScheduled, timeAbacus, this.anchorRemainder);
        if (this.spec.getOptionalRepeatCount() == -1L) {
            this.cachedLastScheduled = nextDue.getScheduled();
            long computed = timeAbacus.calendarGet(this.cachedLastScheduled, this.anchorRemainder);
            return computed - currentTime;
        }
        this.cachedCountRepeated += nextDue.getFactor();
        if (this.cachedCountRepeated <= this.spec.getOptionalRepeatCount()) {
            this.cachedLastScheduled = nextDue.getScheduled();
            long computed = timeAbacus.calendarGet(this.cachedLastScheduled, this.anchorRemainder);
            if (computed > currentTime) {
                return computed - currentTime;
            }
        }
        this.cachedCountRepeated = Long.MAX_VALUE;
        return -1L;
    }
}

