/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverParameterException;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerIntervalObserverForge;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleObserverFactory;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpecComputeForge;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpecComputeFromExprForge;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpecComputeISOStringForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.schedule.ScheduleParameterException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TimerScheduleObserverForge
implements ObserverForge,
ScheduleHandleCallbackProvider {
    protected static final String NAME_OBSERVER = "Timer-schedule observer";
    private static final String ISO_NAME = "iso";
    private static final String REPETITIONS_NAME = "repetitions";
    private static final String DATE_NAME = "date";
    private static final String PERIOD_NAME = "period";
    private static final String[] NAMED_PARAMETERS = new String[]{"iso", "repetitions", "date", "period"};
    private TimerScheduleSpecComputeForge scheduleComputer;
    private MatchedEventConvertorForge convertor;
    private boolean allConstantResult;
    private int scheduleCallbackId = -1;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertorForge convertor, ExprValidationContext validationContext) throws ObserverParameterException {
        Map<String, ExprNamedParameterNode> namedExpressions;
        this.convertor = convertor;
        try {
            namedExpressions = ExprNodeUtilityValidate.getNamedExpressionsHandleDups(parameters);
            ExprNodeUtilityValidate.validateNamed(namedExpressions, NAMED_PARAMETERS);
        }
        catch (ExprValidationException e) {
            throw new ObserverParameterException(e.getMessage(), e);
        }
        ExprNamedParameterNode isoStringExpr = namedExpressions.get(ISO_NAME);
        if (namedExpressions.size() == 1 && isoStringExpr != null) {
            try {
                this.allConstantResult = ExprNodeUtilityValidate.validateNamedExpectType(isoStringExpr, new Class[]{String.class});
            }
            catch (ExprValidationException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
            this.scheduleComputer = new TimerScheduleSpecComputeISOStringForge(isoStringExpr.getChildNodes()[0]);
        } else {
            if (isoStringExpr != null) {
                throw new ObserverParameterException("The 'iso' parameter is exclusive of other parameters");
            }
            if (namedExpressions.size() == 0) {
                throw new ObserverParameterException("No parameters provided");
            }
            this.allConstantResult = true;
            ExprNamedParameterNode dateNamedNode = namedExpressions.get(DATE_NAME);
            ExprNamedParameterNode repetitionsNamedNode = namedExpressions.get(REPETITIONS_NAME);
            ExprNamedParameterNode periodNamedNode = namedExpressions.get(PERIOD_NAME);
            if (dateNamedNode == null && periodNamedNode == null) {
                throw new ObserverParameterException("Either the date or period parameter is required");
            }
            try {
                if (dateNamedNode != null) {
                    this.allConstantResult = ExprNodeUtilityValidate.validateNamedExpectType(dateNamedNode, new Class[]{String.class, Calendar.class, Date.class, Long.class, LocalDateTime.class, ZonedDateTime.class});
                }
                if (repetitionsNamedNode != null) {
                    this.allConstantResult &= ExprNodeUtilityValidate.validateNamedExpectType(repetitionsNamedNode, new Class[]{Integer.class, Long.class});
                }
                if (periodNamedNode != null) {
                    this.allConstantResult &= ExprNodeUtilityValidate.validateNamedExpectType(periodNamedNode, new Class[]{TimePeriod.class});
                }
            }
            catch (ExprValidationException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
            ExprNode dateNode = dateNamedNode == null ? null : dateNamedNode.getChildNodes()[0];
            ExprNode repetitionsNode = repetitionsNamedNode == null ? null : repetitionsNamedNode.getChildNodes()[0];
            ExprTimePeriod periodNode = periodNamedNode == null ? null : (ExprTimePeriod)periodNamedNode.getChildNodes()[0];
            this.scheduleComputer = new TimerScheduleSpecComputeFromExprForge(dateNode, repetitionsNode, periodNode);
        }
        if (this.allConstantResult) {
            try {
                this.scheduleComputer.verifyComputeAllConst(validationContext);
            }
            catch (ScheduleParameterException ex) {
                throw new ObserverParameterException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Unassigned schedule callback id");
        }
        CodegenMethod method = parent.makeChild(TimerScheduleObserverFactory.class, TimerIntervalObserverForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(TimerScheduleObserverFactory.class, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getPatternFactoryService", new CodegenExpression[0]).add("observerTimerSchedule", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setAllConstant", CodegenExpressionBuilder.constant(this.allConstantResult)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleComputer", this.scheduleComputer.make(method, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setOptionalConvertor", this.convertor == null ? null : this.convertor.makeAnonymous(method, classScope)).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public void collectSchedule(List<ScheduleHandleCallbackProvider> schedules) {
        schedules.add(this);
    }
}

